<?php
/**
* ChronoForms 8
* Copyright (c) 2023 ChronoEngine.com, All rights reserved.
* Author: (ChronoEngine.com Team)
* license:     GNU General Public License version 2 or later; see LICENSE.txt
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');
?>
<?php if(isset($_GET["altcha_challenge"]) && $_GET["altcha_challenge"] == "1"): ?>
<?php
	// Clear all previous output buffers
	while (ob_get_level() > 0) {
		ob_end_clean();
	}

	// Start a fresh buffer for this file's own output
	ob_start();

	if(file_exists($this->path.DS.'libs/altcha/autoload.php')){
		require_once($this->path.DS.'libs/altcha/autoload.php');
	}else{
		echo 'Altcha lib not found, you can download the Altcha lib here: <a target="_blank" href="https://www.chronoengine.com/downloads/chronoforms/chronoforms-v8/">Chronoforms v8 downloads</a>';
		return;
	}

	$altcha = new AltchaOrg\Altcha\Altcha($element['secretkey']);

	// Create a new challenge
	$options = new AltchaOrg\Altcha\ChallengeOptions(
		maxNumber: 50000, // the maximum random number
		expires: (new \DateTimeImmutable())->add(new \DateInterval('PT10S')),
	);

	$challenge = $altcha->createChallenge($options);
	echo json_encode($challenge);

	ob_end_flush();

	// Stop script execution
	exit;
?>
<?php else: ?>
<?php Chrono::addHeaderTag("<script type='module' src='https://cdn.jsdelivr.net/gh/altcha-org/altcha/dist/altcha.min.js'></script>"); ?>
<!-- Altcha widget -->
<altcha-widget challengeurl="<?php echo Chrono::r(Chrono::addUrlParam($this->current_url, ["output" => "ajax", "altcha_challenge" => "1"])); ?>" name="altcha" mode="input"></altcha-widget>
<?php endif; ?>