<?php
/**
* ChronoForms 8
* Copyright (c) 2023 ChronoEngine.com, All rights reserved.
* Author: (ChronoEngine.com Team)
* license:     GNU General Public License version 2 or later; see LICENSE.txt
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');
?>
<video id="video_<?php echo $element["id"]; ?>" width="<?php echo $element["video_width"]; ?>" height="<?php echo $element["video_height"]; ?>" autoplay></video>
<canvas id="canvas_<?php echo $element["id"]; ?>" width="<?php echo $element["video_width"]; ?>" height="<?php echo $element["video_height"]; ?>" style="display:none"></canvas>

<button type="button" id="captureBtn_<?php echo $element["id"]; ?>" class="nui button iconed"><?php echo Chrono::ShowIcon("camera"); ?>Capture Photo</button>

<input type="hidden" name="<?php echo $element["fieldname"]; ?>" id="photoInput_<?php echo $element["id"]; ?>">

<img id="preview_<?php echo $element["id"]; ?>" width="<?php echo $element["preview_width"]; ?>" height="<?php echo $element["preview_height"]; ?>">
<script>
    // Start camera
navigator.mediaDevices.getUserMedia({ video: true })
.then(stream => {
    document.getElementById("video_<?php echo $element["id"]; ?>").srcObject = stream;
})
.catch(err => {
    console.error("Camera access error:", err);
});

document.getElementById("captureBtn_<?php echo $element["id"]; ?>").onclick = function () {
    const video = document.getElementById("video_<?php echo $element["id"]; ?>");
    const canvas = document.getElementById("canvas_<?php echo $element["id"]; ?>");
    const ctx = canvas.getContext("2d");

    // Draw the current frame from the video to the canvas
    ctx.drawImage(video, 0, 0, canvas.width, canvas.height);

    // Convert to Base64
    const dataUrl = canvas.toDataURL("image/png");

    // Show preview
    document.getElementById("preview_<?php echo $element["id"]; ?>").src = dataUrl;

    // Store in hidden form field
    document.getElementById("photoInput_<?php echo $element["id"]; ?>").value = dataUrl;
};

</script>