<?php
/**
* ChronoForms 8
* Copyright (c) 2023 ChronoEngine.com, All rights reserved.
* Author: (ChronoEngine.com Team)
* license:     GNU General Public License version 2 or later; see LICENSE.txt
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');
?>
<?php
function paypal_create_payment($element){
	$client_id = $element['client_id'];
    $secret= $element['secret'];
    $mode = $element['mode'];
    $amount = CF8::parse($element['amount']);
    $currency = CF8::parse($element['currency']);
    $return_url = CF8::parse($element['success_url']);
    $cancel_url = CF8::parse($element['cancel_url']);

    $url_token  = $mode=='live' ? 'https://api.paypal.com/v1/oauth2/token' : 'https://api.sandbox.paypal.com/v1/oauth2/token';
    $url_pay    = $mode=='live' ? 'https://api.paypal.com/v1/payments/payment'  : 'https://api.sandbox.paypal.com/v1/payments/payment';

    // get access token
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url_token);
    curl_setopt($ch, CURLOPT_USERPWD, $client_id.":".$secret);
    curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $result = json_decode(curl_exec($ch), true);
    curl_close($ch);

    $token = $result['access_token'];

    // create payment
	$payload = [
		"intent"=>"sale",
		"redirect_urls"=>[
			"return_url"=>$return_url,
			"cancel_url"=>$cancel_url
		],
		"payer"=>["payment_method"=>"paypal"],
		"transactions"=>[
			[
				"amount"=>[
					"total"=>$amount,
					"currency"=>$currency,
					"details" => [
						"subtotal" => $amount,
						"tax" => CF8::parse($element['tax']),
						"shipping" => CF8::parse($element['shipping']),
					],
				],
				"description" => CF8::parse($element['description']),
			]
		]
	];

	// $items = [
	// 	[
	// 		"name" => "Item 1",
	// 		"description" => "Desc 1",
	// 		"price" => "5.00",
	// 		"currency" => "USD",
	// 		"quantity" => "1"
	// 	],
	// 	[
	// 		"name" => "Item 2",
	// 		"description" => "Desc 2",
	// 		"price" => "2.50",
	// 		"currency" => "USD",
	// 		"quantity" => "2"
	// 	]
	// ];

	$items = CF8::parse($element['items']);

	// compute total
	$subtotal = 0;
	foreach($items as $it){
		$subtotal += floatval($it['price']) * intval($it['quantity']);
	}
	$subtotal = number_format($subtotal, 2, '.', '');
	if($subtotal > 0){
		$payload["transactions"][0]["amount"]["details"]["subtotal"] = $subtotal;
		$payload["transactions"][0]["item_list"]["items"] = $items;
	}
	

    $ch = curl_init($url_pay);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
      "Content-Type: application/json",
      "Authorization: Bearer ".$token
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    return json_decode(curl_exec($ch), true);
}

$payment = paypal_create_payment($element);

if(!empty($payment["name"]) && $payment["name"] == "VALIDATION_ERROR"){
	$this->debug[CF8::getname($element)] = $payment;
	$this->errors[] = $payment["details"][0]["issue"];
	$this->set(CF8::getname($element), false);
	return;
}

$approval_url = '';
foreach($payment['links'] as $l){
    if($l['rel'] == 'approval_url'){
        $approval_url = $l['href'];
        break;
    }
}

if($approval_url == ''){
	$this->debug[CF8::getname($element)] = "Could not get approval URL";
	$this->errors[] = $payment["details"][0]["issue"];
	$this->set(CF8::getname($element), false);
	return;
}

$this->redirect($approval_url);