<?php
/**
* ChronoForms 8
* Copyright (c) 2023 ChronoEngine.com, All rights reserved.
* Author: (ChronoEngine.com Team)
* license:     GNU General Public License version 2 or later; see LICENSE.txt
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');
?>
<?php new FormField(name: "elements[$id][client_id]", label: "Client ID", hint: "PayPal Client ID, this depends on the Mode below Test or Live"); ?>
<?php new FormField(name: "elements[$id][secret]", label: "Secret", hint: "PayPal Secret, this depends on the Mode below Test or Live"); ?>

<div class="equal fields">
	<?php new FormField(name: "elements[$id][mode]", type:"select", label: "Live/Test", options:[
		new Option(text:"SandBox", value:"sandbox"),
		new Option(text:"Live", value:"live"),
	]); ?>
</div>

<div class="nui divider large bold">Order information</div>
<div class="equal fields">
	<?php new FormField(name: "elements[$id][currency]", label: "Currency", value:"USD", hint: "3 characters currency code"); ?>
	<?php new FormField(name: "elements[$id][amount]", label: "Amount", value: "10.00", hint: "with 2 decimal points, e.g: 10.00 or 9.99"); ?>
</div>
<div class="equal fields">
	<?php new FormField(name: "elements[$id][tax]", label: "Tax", value: "0.00", hint: "with 2 decimal points, e.g: 10.00 or 9.99"); ?>
	<?php new FormField(name: "elements[$id][shipping]", label: "Shipping", value: "0.00", hint: "with 2 decimal points, e.g: 10.00 or 9.99"); ?>
</div>
<?php new FormField(name: "elements[$id][items]", label: "Items List", value: "", hint: "A shortcode returning an array of items, each item is an array which has the keys: name, description, price, currency, quantity"); ?>

<?php new FormField(name: "elements[$id][success_url]", label: "Success URL", hint: "A url on your website to return the user to after the purchase"); ?>
<?php new FormField(name: "elements[$id][cancel_url]", label: "Cancel URL", hint: "A url on your website to return the user to if they cancel the purchase."); ?>

<?php new FormField(name: "elements[$id][description]", label: "Description", hint:'Your payment description'); ?>

<?php
$behaviors = ["paypal_redirect.parameters"];
$listBehaviors($id, $behaviors);
?>