<?php

/**
 * @package     Joomla.Site
 * @subpackage  Templates.Puebla
 *
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
// Cargar CSS y JS de UIkit desde la plantilla
$wa->registerAndUseStyle('uikit', 'templates/' . $this->template . '/uikit-3.23.5/css/uikit.min.css');
$wa->registerAndUseScript('uikit', 'templates/' . $this->template . '/uikit-3.23.5/js/uikit.min.js', ['defer' => true]);
$wa->registerAndUseScript('uikit-icons', 'templates/' . $this->template . '/uikit-3.23.5/js/uikit-icons.min.js', ['defer' => true]);

/** @var Joomla\CMS\Document\HtmlDocument $this */
$app   = Factory::getApplication();
$input = $app->getInput();
$wa    = $this->getWebAssetManager();
$wa->usePreset('template.puebla');

// Browsers support SVG favicons
//$this->addHeadLink(HTMLHelper::_('image', 'joomla-favicon.svg', '', [], true, 1), 'icon', 'rel', ['type' => 'image/svg+xml']);
//$this->addHeadLink(HTMLHelper::_('image', 'favicon.ico', '', [], true, 1), 'alternate icon', 'rel', ['type' => 'image/vnd.microsoft.icon']);
//$this->addHeadLink(HTMLHelper::_('image', 'joomla-favicon-pinned.svg', '', [], true, 1), 'mask-icon', 'rel', ['color' => '#000']);
$this->addHeadLink('/templates/' . $this->template . '/favicon.ico', 'icon', 'rel', ['type' => 'image/x-icon']);

// Detecting Active Variables
$option   = $input->getCmd('option', '');
$view     = $input->getCmd('view', '');
$layout   = $input->getCmd('layout', '');
$task     = $input->getCmd('task', '');
$itemid   = $input->getCmd('Itemid', '');
$sitename = htmlspecialchars($app->get('sitename'), ENT_QUOTES, 'UTF-8');
$menu     = $app->getMenu()->getActive();
$pageclass = $menu !== null ? $menu->getParams()->get('pageclass_sfx', '') : '';

// Color Theme
$paramsColorName = $this->params->get('colorName', 'colors_standard');
$assetColorName  = 'theme.' . $paramsColorName;

// Enable assets
$wa 
    ->registerAndUseStyle($assetColorName, 'global/' . $paramsColorName . '.css')
    
    ->addInlineStyle(':root {
		--hue: 214;
		--template-bg-light: #f0f4fb;
		--template-text-dark: #495057;
		--template-text-light: #ffffff;
		--template-link-color: var(--link-color);
		--template-special-color: #001B4C;
		$fontStyles
	}');

//Logos
if($this->params->get('logoSecre')){
    $logoSecre = '<img class="img-header" src="' . $this->params->get('logoSecre') . ' "  />' ;
}

if($this->params->get('logoSecretaria')){
    $logoSecretaria = '<img class="img-header" src="' . $this->params->get('logoSecretaria') . ' "  />' ;
}
    
    
// Container
$wrapper = $this->params->get('fluidContainer') ? 'wrapper-fluid' : 'wrapper-static';
$this->setMetaData('viewport', 'width=device-width, initial-scale=1');
$stickyHeader = $this->params->get('stickyHeader') ? 'position-sticky sticky-top' : '';


$wa = $this->getWebAssetManager();
$wa->useScript('template.puebla.templatejs');

?>
<!DOCTYPE html>
<html>

<head>
    <jdoc:include type="metas" />
    <jdoc:include type="styles" />
    <jdoc:include type="scripts" />
</head>

<header class="header" id="header">
  <div class="uk-grid header-inner" uk-grid>
    <div class="uk-width-3-5@s uk-padding-remove">
      <div class="uk-flex uk-flex-left uk-flex-middle uk-flex-nowrap">
        <!-- Escudo -->
        <div>
          <a href="https://puebla.gob.mx">
            <img src="templates/<?= $this->template ?>/images/header/logo_puebla_gob.svg"
              class="img-header" alt="Logo Puebla Gobierno">
          </a>
        </div>
        <!-- Logo Secretaría -->
        <?php if (!empty($logoSecretaria)) : ?>
        <div>
          <a href="/sb">
            <?= str_replace('<img', '<img class="img-header" alt="Logo de Secretaría"', $logoSecretaria) ?>
          </a>
        </div>
        <?php endif; ?>
        <!-- Logo Subsecretaría -->
        <?php if (!empty($logoSecre)) : ?>
        <div>
          <?= str_replace('<img', '<img class="img-header" alt="Logo de Subsecretaría"', $logoSecre) ?>
        </div>
        <?php endif; ?>
      </div>
    </div>
    <div class="uk-width-2-5@s uk-padding-remove uk-visible@s">
      <div class="uk-flex uk-flex-right uk-flex-middle uk-flex-nowrap">
        <!-- Frase -->
        <div>
          <img src="templates/<?= $this->template ?>/images/header/puebla_frases_gob.svg"
            class="img-header" alt="Frase Amor a Puebla Gobierno" style="padding-left: 20px;">
        </div>
        <!-- Accesibilidad escritorio -->
        <div id="accesibilidad-position-desktop" class="uk-margin-small-left"></div>
      </div>
    </div>
  </div>

  <div class="uk-margin-remove uk-flex uk-flex-middle uk-visible@s" uk-grid>
    <!-- Menú -->
    <div class="uk-width-expand@m uk-padding-remove">
      <?php if ($this->countModules('menu')) : ?>
      <div class="menu-container">
        <jdoc:include type="modules" name="menu" style="xhtml" />
      </div>
      <?php endif; ?>
    </div>
    <!-- Search escritorio -->
    <div class="uk-width-1-5@m uk-margin-remove">
      <div id="search-position-desktop" class="search-container uk-margin-remove uk-padding-small uk-align-right"></div>
    </div>
  </div>

  <div class="menu-container uk-grid uk-child-width-1-3 uk-flex-middle uk-margin-remove uk-padding-remove uk-hidden@s" uk-grid>
    <!-- Search móvil -->
    <div class="uk-text-left">
      <div id="search-position-mobile" class="search-container"></div>
    </div>
    <!-- Menú offcanvas -->
    <div class="uk-text-center">
      <?php if ($this->countModules('offcanvas')) : ?>
      <a href="#offcanvas" class="uk-hidden@s c-484747 bgch-484747" uk-toggle="target: #offcanvas-flip">
        <span uk-icon="icon: menu; ratio: 2"></span>
      </a>
      <?php endif; ?>
    </div>
    <!-- Accesibilidad móvil -->
    <div class="uk-text-right">
      <div id="accesibilidad-position-mobile" class="accesibilidad-container uk-margin-remove  uk-align-right"></div>
    </div>
  </div>
</header>

<!-- Módulos Repetidos -->
<div style="display: none;">
  <div id="search-module">
    <?php if ($this->countModules('search')) : ?>
      <jdoc:include type="modules" name="search" style="xhtml" />
    <?php endif; ?>
  </div>
  <div id="accesibilidad-module">
    <img src="templates/<?= $this->template ?>/images/header/logo_accesibilidad.svg"
         class="img-access" alt="Accesibilidad" />
  </div>
</div>

<body>
    <div class="body">
        <?php if ($this->countModules('slider')) : ?>
        <div class="slider">
            <div class="uk-margin-top">
                <jdoc:include type="modules" name="slider" style="wrap" />
            </div>
        </div>
        <?php endif; ?>

        <?php if ($this->countModules('contact')) : ?>
        <div class="contact">
            <div class="container">
                <jdoc:include type="modules" name="contact" style="wrap" />
            </div>
        </div>
        <?php endif; ?>

        <?php if ($this->countModules('above-top')) : ?>
        <div class="above-top">
            <div class="container">
                <jdoc:include type="modules" name="above-top" style="wrap" />
            </div>
        </div>
        <?php endif; ?>

        <?php if ($this->countModules('above-bottom')) : ?>
        <div class="above-bottom">
            <div class="container">
                <jdoc:include type="modules" name="above-bottom" style="wrap" />
            </div>
        </div>
        <?php endif; ?>

        <?php if ($this->countModules('main-top')) : ?>
        <div class="main-top">
            <div class="container">
                <jdoc:include type="modules" name="main-top" style="wrap" />
            </div>
        </div>
        <?php endif; ?>

        <div class="grid-child container-component">
            <jdoc:include type="modules" name="breadcrumbs" style="none" />
            <jdoc:include type="message" />
            <main>
                <jdoc:include type="component" />
            </main>
        </div>

        <?php if ($this->countModules('main-bottom')) : ?>
        <div class="main-bottom">
            <div class="container">
                <jdoc:include type="modules" name="main-bottom" style="wrap" />
            </div>
        </div>    
        <?php endif; ?>
        
        <?php if ($this->countModules('below-top')) : ?>
        <div class="below-top">
            <div class="container">
                <jdoc:include type="modules" name="below-top" style="wrap" />
            </div>
        </div>
        <?php endif; ?>

        <?php if ($this->countModules('below-bottom')) : ?>
        <div class="below-bottom">
            <div class="">
                <jdoc:include type="modules" name="below-bottom" style="wrap" />
            </div>
        </div>
        <?php endif; ?>
    </div>

    <footer class="footer  uk-position-relative">
        <div class="uk-container footer-container uk-container uk-flex uk-flex-center">
            <div
                class="uk-position-absolute uk-padding-remove uk-margin-remove uk-width-1-1 uk-flex uk-flex-center sombra-footer">
                <!-- Imagen vertical para pantallas grandes -->
                <img src="templates/<?= $this->template ?>/images/footer/sombra_vertical.png"
                    class="sombra-vertical uk-visible@m" alt="Sombra Vertical">

            </div>
            <div class="uk-flex uk-flex-middle uk-flex-center uk-padding-remove uk-margin-remove" uk-grid>
                <div class="uk-width-1-2@xl uk-width-1-2@l uk-width-1-2@m uk-width-1-2@s uk-width-1-1@xs">
                    <?php if ($this->countModules('footer-left')) : ?>
                    <div class="uk-flex uk-flex-middle uk-flex-center uk-padding">
                        <jdoc:include type="modules" name="footer-left" style="wrap" />
                    </div>
                    <?php endif; ?>
                </div>
                <!-- Imagen horizontal para pantallas pequeñas -->
                <img src="templates/<?= $this->template ?>/images/footer/sombra_horizontal.png"
                    class="sombra-horizontal uk-hidden@m" alt="Sombra Horizontal">
                <div class="uk-width-1-2@xl uk-width-1-2@l uk-width-1-2@m uk-width-1-2@s uk-width-1-1@xs">
                    <?php if ($this->countModules('footer-right')) : ?>
                    <div class="uk-flex uk-flex-middle uk-flex-center uk-padding">
                        <jdoc:include type="modules" name="footer-right" style="wrap" />
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

    </footer>
    
    <div class="copyright">
        <div class="uk-width-1-1 uk-flex uk-flex-center uk-padding-remove uk-margin-remove">
            <?php if ($this->countModules('copyright')) : ?>
            <div class="copyright-container  uk-padding-remove uk-margin-remove">
                <jdoc:include type="modules" name="copyright" style="wrap" />
            </div>
            <?php endif; ?>
        </div>
    </div>


    <jdoc:include type="modules" name="debug" style="none" />
    <?php if ($this->countModules('offcanvas')) : ?>
    <div id="offcanvas-flip" uk-offcanvas="mode: push; overlay: true; flip: true">
        <div class="uk-offcanvas-bar uk-padding-remove">
            <button class="uk-offcanvas-close" type="button" uk-close></button>
             <h3 class="uk-padding uk-padding-remove-bottom uk-margin-remove"><?php echo $sitename; ?></h3>
            <jdoc:include type="modules" name="offcanvas" style="wrap" />
        </div>
    </div>
    <?php endif; ?>
    <?php echo $this->params->get('googleAnalytics'); ?>
</body>

</html>