<?php

defined('_JEXEC') or die;

use Joomla\CMS\Helper\ModuleHelper;
use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

$doc = Factory::getDocument();
$doc->addStyleSheet(Uri::base() . 'templates/puebla/html/mod_menu/css/style.css');

$wa = $app->getDocument()->getWebAssetManager();
$wa->registerAndUseScript(
    'metismenu',
    'media/templates/site/cassiopeia/js/mod_menu/menu-metismenu.min.js',
    [],
    ['defer' => true],
    ['metismenujs']
);

// Colores 
$colors = ['color1', 'color2', 'color3', 'color4','color5', 'color6'];

// Atributos del <ul>
$attributes = [];
$attributes['class'] = 'uk-grid custom-grid uk-flex uk-flex-center uk-child-width-1-2@s uk-child-width-1-3@m uk-grid-match uk-grid-small' . $class_sfx;

if ($tagId = $params->get('tag_id', '')) {
    $attributes['id'] = $tagId;
}

$start = (int) $params->get('startLevel', 1);
?>

<ul <?php echo ArrayHelper::toString($attributes); ?>>
<?php foreach ($list as $i => $item) :
    if (!$showAll && $item->level > $start) {
        continue;
    }

    $itemParams = $item->getParams();

    // Card
    $liClass = 'metismenu-item uk-margin-bottom item-' . $item->id . ' level-' . ($item->level - $start + 1);
    $colorClass = $colors[$i % count($colors)];
    $cardClass = 'uk-card uk-card-default uk-card-body custom-card ' . $colorClass;

    if ($item->id == $default_id) $liClass .= ' default';
    if ($item->id == $active_id || ($item->type === 'alias' && $itemParams->get('aliasoptions') == $active_id)) $liClass .= ' current';
    if (in_array($item->id, $path)) $liClass .= ' active';

    elseif ($item->type === 'alias') {
        $aliasToId = $itemParams->get('aliasoptions');
        if (count($path) > 0 && $aliasToId == $path[count($path) - 1]) {
            $liClass .= ' active';
        } elseif (in_array($aliasToId, $path)) {
            $liClass .= ' alias-parent-active';
        }
    }

    if ($item->type === 'separator') $liClass .= ' divider';
    if ($showAll && $item->deeper) $liClass .= ' deeper';
    if ($showAll && $item->parent) $liClass .= ' parent';

    echo '<li class="' . $liClass . '">';
    echo '<div class="' . $cardClass . '">';

    //item
    switch ($item->type) :
        case 'separator':
            if ($showAll && $item->deeper) {
                echo '<div class="uk-inline">';
                echo '<a class="uk-link-toggle" href="#" uk-toggle>'
                    . htmlspecialchars($item->title, ENT_QUOTES, 'UTF-8') . '</a>';
                echo '<div uk-dropdown="animation: uk-animation-slide-top-small">';
            } else {
                require ModuleHelper::getLayoutPath('mod_menu', 'dst-treegrid_separator');
            }
            break;

        case 'component':
        case 'heading':
        case 'url':
            require ModuleHelper::getLayoutPath('mod_menu', 'dst-treegrid_' . $item->type);
            break;

        default:
            require ModuleHelper::getLayoutPath('mod_menu', 'dst-treegrid_url');
    endswitch;
    echo '</div>';

    // Niveles
    switch (true) :
        case $showAll && $item->deeper:
            echo '<ul class="uk-nav uk-dropdown-nav">';
            break;

        case $item->shallower:
            echo '</li>';
            echo str_repeat('</ul></li>', $item->level_diff);
            if ($list[$i - 1]->type === 'separator' && $list[$i - 1]->deeper) {
                echo '</div></div>'; 
            }
            break;

        default:
            echo '</li>';
            break;
    endswitch;

endforeach; ?>
</ul>
