<?php 
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;
use Joomla\CMS\Uri\Uri;

if ($params->get('articles_layout') == 1) {
    $gridCols = 'grid-cols-' . $params->get('layout_columns');
}
?>

<div class="uk-container uk-padding">

    <?php if (!empty($items)) : ?>
    <h2 class=" uk-text-center"><?php echo htmlspecialchars($items[0]->category_title); ?></h2>
    <?php endif; ?>

    <ul
        class="uk-list mod-articles-items<?php echo ($params->get('articles_layout') == 1 ? ' mod-articles-grid ' . $gridCols : ''); ?> mod-list">

        <?php foreach ($items as $item) : ?>
        <?php
                // Obtener campos personalizados del artículo
                $fields = FieldsHelper::getFields('com_content.article', $item, true);
                $archivos = [];

                foreach ($fields as $field) {
                    if ($field->name === 'multimedia-archivos') {
                        $raw = $field->rawvalue;
                        $data = json_decode($raw, true);

                        if (is_array($data)) {
                            foreach ($data as $row) {
                                $titulo = trim($row['field1'] ?? '');
                                $ruta   = trim($row['field2'] ?? '');

                                if ($ruta) {
                                    $url = (strpos($ruta, 'http') === 0) ? $ruta : Uri::root() . ltrim($ruta, '/');
                                    $archivos[] = [
                                        'titulo' => $titulo,
                                        'url'    => $url
                                    ];
                                }
                            }
                        }
                    }
                }
            ?>

        <?php foreach ($archivos as $archivo) : ?>
        <li class="aviso-item uk-padding">
            <!-- Enlace que abre el modal -->
            <a href="#modal-<?php echo md5($archivo['url']); ?>" uk-toggle>
                <?php echo htmlspecialchars($archivo['titulo']); ?>
            </a>

            <!-- Modal con iframe y botones -->
            <div id="modal-<?php echo md5($archivo['url']); ?>" class="uk-flex-top" uk-modal>
                <div class="uk-modal-dialog uk-width-auto uk-margin-auto-vertical" style="width:90vw; height:90vh;">
                    <button class="uk-modal-close-outside" type="button" uk-close></button>

                    <iframe src="<?php echo htmlspecialchars($archivo['url']); ?>" style="width:100%; height:90%;"
                        frameborder="0"></iframe>

                    <div class="uk-modal-footer uk-text-right">
                        <a href="<?php echo htmlspecialchars($archivo['url']); ?>" class="uk-button uk-button-primary"
                            download target="_blank">Descargar</a>
                        <button class="uk-button uk-button-default uk-modal-close" type="button">Cancelar</button>
                    </div>
                </div>
            </div>
        </li>
        <?php endforeach; ?>
        <?php endforeach; ?>
    </ul>
</div>

<style>
.aviso-item {
    background: #d8d2c6;
    padding: 1rem 3rem;
    text-transform: uppercase;
    margin-bottom: 1rem;
    color: #3c4145;
}

.uk-toggle,
.uk-modal {
    z-index: 10000 !important;
}
</style>