<?php
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;
use Joomla\CMS\Uri\Uri;

if ($params->get('articles_layout') == 1) {
    $gridCols = 'grid-cols-' . $params->get('layout_columns');
}
?>

<div class="uk-container uk-padding">

    <?php if (!empty($items)) : ?>
      <!--  <h2 class="uk-text-center"><?php echo htmlspecialchars($items[0]->category_title); ?></h2>-->
    <?php endif; ?>

    <ul class="uk-list mod-articles-items<?php echo ($params->get('articles_layout') == 1 ? ' mod-articles-grid ' . $gridCols : ''); ?> mod-list">

    <?php foreach ($items as $item) : ?>
        <?php
        // Obtener campos personalizados del artículo
        $fields = FieldsHelper::getFields('com_content.article', $item, true);
        $archivos = [];

        foreach ($fields as $field) {
            if ($field->name === 'multimedia') {
                $raw = $field->rawvalue;

                // Normalizar el contenido: puede venir como JSON string o como array ya decodificado
                $data = null;
                if (is_string($raw) && trim($raw) !== '') {
                    $data = json_decode($raw, true);
                    if (json_last_error() !== JSON_ERROR_NONE) {
                        // si hay error en JSON, intenta ver si es un string simple
                        $data = null;
                    }
                } elseif (is_array($raw)) {
                    $data = $raw;
                }

                // Si no vino JSON válido, intenta forzar un array con el valor crudo
                if (!is_array($data)) {
                    // Debug opcional:
                    // error_log('Multimedia rawvalue inválido para artículo ' . $item->id . ': ' . var_export($raw, true));
                    continue;
                }

                // Recorre filas del subform
                foreach ($data as $row) {
                    // Dependiendo de cómo estén los campos en tu subform, el nombre real del índice puede variar.
                    // Aquí asumimos que la imagen está en 'field4' y el título en 'field3' (ajusta si tu estructura es distinta).
                    $titulo = trim($row['field3'] ?? ($row['title'] ?? '')) ;
                    $campoImagen = $row['field4'] ?? ($row['image'] ?? '');

                    if (!$campoImagen) {
                        continue;
                    }

                    // Si el campo de imagen puede contener varias rutas (array o string separada), normaliza a array
                    $imagenes = [];
                    if (is_array($campoImagen)) {
                        $imagenes = $campoImagen;
                    } else {
                        // separar por comas o por barra vertical si existe
                        if (strpos($campoImagen, '|') !== false) {
                            $imagenes = array_map('trim', explode('|', $campoImagen));
                        } elseif (strpos($campoImagen, ',') !== false) {
                            $imagenes = array_map('trim', explode(',', $campoImagen));
                        } else {
                            $imagenes = [trim($campoImagen)];
                        }
                    }

                    foreach ($imagenes as $img) {
                        if (!$img) continue;
                        $url = (strpos($img, 'http') === 0) ? $img : Uri::root() . ltrim($img, '/');
                        $archivos[] = [
                            'titulo' => $titulo ?: basename($img),
                            'url'    => $url
                        ];
                    }
                }
            }
        }
        ?>

        <?php if (!empty($archivos)) : ?>
            <li class=" uk-padding">
                <h3 class="uk-text-center" style ="color:#991232">Galería</h3>

                <!-- Slider UIkit (muestra miniaturas y se puede abrir la galería) -->
                <div uk-slider="finite: true" class="uk-position-relative uk-visible-toggle uk-light" tabindex="-1">

                    <ul class="uk-slider-items uk-grid">
                        <?php foreach ($archivos as $idx => $archivo) : ?>
                            <li class="uk-width-1-3@s uk-width-1-2" uk-lightbox>
                                <a href="<?php echo htmlspecialchars($archivo['url']); ?>"  >
                                    <img src="<?php echo htmlspecialchars($archivo['url']); ?>" alt="<?php echo htmlspecialchars($archivo['titulo']); ?>" style="width:100%; height:auto; display:block;" />
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>

                    <a class="uk-position-center-left uk-position-small uk-hidden-hover" href="#" uk-slidenav-previous uk-slider-item="previous"></a>
                    <a class="uk-position-center-right uk-position-small uk-hidden-hover" href="#" uk-slidenav-next uk-slider-item="next"></a>

                </div>

                <!-- Opcional: enlaces individuales / descarga - ->
                <div class="uk-margin-top">
                    <?php foreach ($archivos as $archivo) : ?>
                        <a class="uk-button uk-button-text" href="<?php echo htmlspecialchars($archivo['url']); ?>" target="_blank" rel="noopener"><?php echo htmlspecialchars($archivo['titulo']); ?></a>
                    <?php endforeach; ?>
                </div>-->
            </li>
        <?php endif; ?>

    <?php endforeach; ?>
    </ul>
</div>

<style>
.aviso-item {
    /*background: #d8d2c6;*/
    padding: 1rem;
    text-transform: uppercase;
    margin-bottom: 1rem;
    color: #3c4145;
}



/* Ajustes responsivos del slider */
.uk-slider-items img {
    max-height: 200px;
    object-fit: cover;
}
.uk-lightbox{
    z-index:10001;
}
</style>
