<?php
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Date\Date;
?>

<?php if (!empty($items)) : ?>
<div class="uk-text-center uk-padding">
    <h2>Galería</h2>
</div>
<div class="uk-container uk-margin galery">

    <!-- Imagen principal (la primera del array) -->
    <div id="main-image">
        <img class="uk-align-center uk-width-expand" id="main-img"
            src="<?php echo htmlspecialchars(json_decode($items[0]->images)->image_intro); ?>" alt="">
    </div>

    <!-- Slider de miniaturas -->
    <div id="thumbnails" uk-slider="center: true; autoplay: true">
        <div class="uk-position-relative uk-visible-toggle uk-light" tabindex="-1">
            <ul class="uk-slider-items uk-child-width-1-2 uk-child-width-1-3@s uk-child-width-1-6@m">

                <?php foreach ($items as $item) :
                    $images = json_decode($item->images);
                    if (!empty($images->image_intro)) :
                        $imgSrc = htmlspecialchars($images->image_intro);
                ?>
                <li class="uk-transition-toggle thumbnail" tabindex="0">
                    <img src="<?php echo $imgSrc; ?>" width="100" height="80"
                        alt="<?php echo htmlspecialchars($item->title); ?>">
                </li>
                <?php endif; endforeach; ?>

            </ul>

            <a class="uk-position-center-left uk-position-small uk-hidden-hover" href="#" uk-slidenav-previous
                uk-slider-item="previous"></a>
            <a class="uk-position-center-right uk-position-small uk-hidden-hover" href="#" uk-slidenav-next
                uk-slider-item="next"></a>
        </div>
    </div>
</div>

<!-- Script para cambiar la imagen principal -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const mainImg = document.getElementById('main-img');
    const thumbnails = document.querySelectorAll('#thumbnails .thumbnail img');

    thumbnails.forEach(function(thumb) {
        thumb.addEventListener('click', function() {
            mainImg.src = this.src;
        });
    });
});
</script>

<!-- Estilos -->
<style>
.galery {
    padding: 1rem;
    background-color: #f4f4f4;
    border-radius: 8px;
}

.thumbnail {
    cursor: pointer;
}

#main-img {
    max-height: 500px;
    object-fit: contain;
}
</style>
<?php endif; ?>