<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_articles
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Factory;

// Cargar el CSS del efecto "libro"
$doc = Factory::getDocument();
$doc->addStyleDeclaration("
.content-book {
    position: relative;
}
.content-book>.book {
    width: 220px;
    height: 200px;
    margin-top: 50px;
}
.content-book>.book>.cover {
    cursor: pointer;
    position: relative;
    width: 80%;
    height: 80%;
    background-color: #6a1d31;
    border-radius: 0 0 10px 10px;
}
.content-book>.book>.cover:before,
.content-book>.book>.cover:after {
    box-sizing: border-box;
    content: '';
    display: block;
    position: absolute;
    top: -100px;
    border: 50px solid transparent;
}
.content-book>.book>.cover:before {
    left: 0;
    width: 50%;
    border-left: none;
    border-bottom-color: #6a1d31;
}
.content-book>.book>.cover>.title {
    position: absolute;
    padding: 0.5em;
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
}
.content-book>.book>.cover>.title h3 {
    padding:20px;
    font-size: 11px;
    font-weight: bold;
    text-align: center;
    color: white;
    margin: 0;
}
.content-book>.book>.paper {
    opacity: 1;
    position: absolute;
    overflow: hidden;
    width: 150px;
    height: 200px;
    top: calc(50% - 160px);
    left: calc(50% - 125px);
    transition: top 0.5s, opacity 0.4s;
    font-family: Verdana, Tahoma, sans-serif;
    font-size: 0.1em;
    padding: 1em;
    color: #644913;
    background-color: #fde2ac;
    box-shadow: 10px 10px rgba(0, 0, 0, 0.2);
    border-radius: 5px;
}
.content-book>.book:hover>.paper {
    top: calc(50% - 200px);
}
");

if ($params->get('articles_layout') == 1) {
    $gridCols = 'grid-cols-' . $params->get('layout_columns');
}
?>

<ul
    class="uk-list mod-articles-items<?php echo ($params->get('articles_layout') == 1 ? ' mod-articles-grid ' . $gridCols : ''); ?> mod-list">
    <?php foreach ($items as $item) : ?>
    <?php $displayInfo = $item->displayHits || $item->displayAuthorName || $item->displayCategoryTitle || $item->displayDate; ?>
    <li>
        <article class="mod-articles-item" itemscope itemtype="https://schema.org/Article">
            <?php if ($params->get('item_title') || $displayInfo || $params->get('show_tags') || $params->get('show_introtext') || $params->get('show_readmore')) : ?>
            <div class="mod-articles-item-content">

                <?php if ($params->get('item_title')) : ?>
                <?php $item_heading = $params->get('item_heading', 'h4'); ?>
                <<?php echo $item_heading; ?> class="mod-articles-title" itemprop="name">
                    <?php if ($params->get('link_titles') == 1) : ?>
                    <?php $attributes = ['class' => 'mod-articles-link ' . $item->active, 'itemprop' => 'url']; ?>
                    <?php $link = htmlspecialchars($item->link, ENT_COMPAT, 'UTF-8', false); ?>
                    <?php $title = htmlspecialchars($item->title, ENT_COMPAT, 'UTF-8', false); ?>
                    <?php echo HTMLHelper::_('link', $link, $title, $attributes); ?>
                    <?php else : ?>
                    <?php echo $item->title; ?>
                    <?php endif; ?>
                </<?php echo $item_heading; ?>>
                <?php endif; ?>

                <?php echo $item->event->afterDisplayTitle; ?>

                <?php if ($displayInfo) : ?>
                <dl class="list-inline">
                    <?php if ($item->displayAuthorName) : ?>
                    <dd class="mod-articles-writtenby list-inline-item">
                        <?php echo LayoutHelper::render('joomla.icon.iconclass', ['icon' => 'icon-user icon-fw']); ?>
                        <?php echo $item->displayAuthorName; ?>
                    </dd>
                    <?php endif; ?>

                    <?php if ($item->displayCategoryTitle) : ?>
                    <dd class="mod-articles-category list-inline-item">
                        <?php echo LayoutHelper::render('joomla.icon.iconclass', ['icon' => 'icon-folder-open icon-fw']); ?>
                        <?php if ($item->displayCategoryLink) : ?>
                        <a href="<?php echo $item->displayCategoryLink; ?>">
                            <?php echo $item->displayCategoryTitle; ?>
                        </a>
                        <?php else : ?>
                        <?php echo $item->displayCategoryTitle; ?>
                        <?php endif; ?>
                    </dd>
                    <?php endif; ?>

                    <?php if ($item->displayDate) : ?>
                    <dd class="mod-articles-date list-inline-item">
                        <?php echo LayoutHelper::render('joomla.icon.iconclass', ['icon' => 'icon-calendar icon-fw']); ?>
                        <?php echo $item->displayDate; ?>
                    </dd>
                    <?php endif; ?>

                    <?php if ($item->displayHits) : ?>
                    <dd class="mod-articles-hits list-inline-item">
                        <?php echo LayoutHelper::render('joomla.icon.iconclass', ['icon' => 'icon-eye icon-fw']); ?>
                        <?php echo $item->displayHits; ?>
                    </dd>
                    <?php endif; ?>
                </dl>
                <?php endif; ?>

                <?php if (in_array($params->get('img_intro_full'), ['intro', 'full']) && !empty($item->imageSrc)) : ?>
                <?php echo LayoutHelper::render('joomla.content.' . $params->get('img_intro_full') . '_image', $item); ?>
                <?php endif; ?>

                <?php if ($params->get('show_tags', 0) && $item->tags->itemTags) : ?>
                <div class="mod-articles-tags">
                    <?php echo LayoutHelper::render('joomla.content.tags', $item->tags->itemTags); ?>
                </div>
                <?php endif; ?>

                <?php echo $item->event->beforeDisplayContent; ?>

                <?php if ($params->get('show_introtext', 1)) : ?>
                <?php echo $item->displayIntrotext; ?>
                <?php endif; ?>

                <?php echo $item->event->afterDisplayContent; ?>

                <?php if ($params->get('show_readmore')) : ?>
                <?php echo LayoutHelper::render('joomla.content.readmore', ['item' => $item, 'params' => $item->params, 'link' => $item->link]); ?>
                <?php endif; ?>

                <?php
                // Archivos tipo "libro"
                $fields = FieldsHelper::getFields('com_content.article', $item, true);
                $documentos = [];

                foreach ($fields as $field) {
                    if ($field->name === 'multimedia-archivos') {
                        $rows = json_decode($field->rawvalue, true);
                        if (is_array($rows)) {
                            $documentos = $rows;
                        }
                    }
                }

                if (!empty($documentos)) : ?>
                <div class="uk-padding-small uk-margin-top">
                    <ul class="uk-flex uk-flex-center" uk-grid>
                        <?php foreach ($documentos as $doc) :
                                $titulo = trim($doc['field1'] ?? '');
                                $ruta = trim($doc['field2'] ?? '');

                                if (!$ruta) continue;

                                $href = (strpos($ruta, 'http') === 0) ? $ruta : Uri::root() . ltrim($ruta, '/');
                                ?>
                        <li class="uk-width-1-4@l uk-width-1-4@m uk-width-1-2@s uk-text-center">
                            <a title="<?php echo htmlspecialchars($titulo); ?>"
                                href="<?php echo htmlspecialchars($href); ?>" class="content-book-link" download>
                                <div class="content-book">
                                    <div class="book">
                                        <div class="paper"></div>
                                        <div class="cover">
                                            <div class="title">
                                                <h3><?php echo htmlspecialchars($titulo); ?></h3>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </a>
                            <span></span>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>

            </div>
            <?php endif; ?>
        </article>
    </li>
    <?php endforeach; ?>
</ul>