<?php
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;
use Joomla\CMS\Date\Date;


?>



<div class="uk-container uk-grid-small uk-child-width-1-3@m uk-grid-match uk-padding uk-flex uk-flex-center" uk-grid>
    <?php foreach ($items as $item) : ?>
    <?php
        $images = json_decode($item->images);
        $introImage = isset($images->image_intro) ? $images->image_intro : '';

        $date = new Date($item->publish_up);
        $fechaFormateada = HTMLHelper::_('date', $date, 'l, d F Y H:i');
        $fechaFormateada = Text::_($fechaFormateada);

        $introResumen = HTMLHelper::_('string.truncate', strip_tags($item->introtext), 200, true, false);
        ?>
    <div>
        <div class="uk-card uk-overflow-hidden">
            <?php if (!empty($introImage)) : ?>
            <a href="<?php echo $item->link; ?>" class="uk-inline-clip uk-transition-toggle uk-light" tabindex="0">
                <img src="<?php echo htmlspecialchars($introImage); ?>"
                    alt="<?php echo htmlspecialchars($item->title); ?>" class="uk-width-1-1" />

                <div class="uk-transition-fade uk-position-cover" style="background: rgba(0, 0, 0, 0.45);"></div>

                <div class="uk-transition-fade uk-position-center">
                    <p class="uk-margin-remove uk-text-bold c-fff uk-text-center">
                        <?php echo htmlspecialchars($item->title); ?>
                    </p>
                </div>
            </a>
            <?php endif; ?>
        </div>
    </div>
    <?php endforeach; ?>
</div>