<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\Component\Banners\Site\Helper\BannerHelper;


$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$wa->registerAndUseStyle('mod_banners.custom-style', 'templates/puebla_salud_interna/html/mod_banners/css/style.css');
?>

<div class="banners-cards uk-margin-bottom">
    <div class="uk-child-width-1-1@s uk-grid-match" uk-grid>
        <?php foreach ($list as $item) : //echo "<pre>".print_r($item, true)."</pre>"; ?>
        <div class="uk-margin-small">
            <div class="uk-card uk-card-small uk-card-default uk-card-hover uk-card-body">
                <?php $link = JRoute::_('index.php?option=com_banners&task=click&id=' . $item->id); ?>
                <?php $imageurl = $item->params->get('imageurl'); ?>
                <?php $width = $item->params->get('width'); ?>
                <?php $height = $item->params->get('height'); ?>
                <?php if (BannerHelper::isImage($imageurl)) : ?>
                <?php // Image based banner ?>
                <?php $baseurl = strpos($imageurl, 'http') === 0 ? '' : JUri::base(); ?>
                <?php $alt = $item->params->get('alt'); ?>
                <?php 
                
                    //$enablealt = false; 
                    //if(trim($alt)) $enablealt=true; 
                    $alt = $item->params->get('alt');
                    $alt = $alt ?: $item->name;
                    $alt = $alt ?: JText::_('MOD_BANNERS_BANNER');
                    $enablealt = trim((string) $alt) !== '';

                ?>
                <?php $alt = $alt ?: $item->name; ?>
                <?php $alt = $alt ?: JText::_('MOD_BANNERS_BANNER');?>
                <?php if ($item->clickurl) : ?>
                <?php // Wrap the banner in a link ?>
                <?php $target = $params->get('target', 1); ?>
                <?php if ($target == 1) : ?>
                <?php // Open in a new window ?>
                <a href="<?php echo $link; ?>" target="_blank" rel="noopener noreferrer"
                    title="<?php echo htmlspecialchars($item->name, ENT_QUOTES, 'UTF-8'); ?>">
                    <img src="<?php echo $baseurl . $imageurl; ?>"
                        alt="<?php echo htmlspecialchars($alt, ENT_QUOTES, 'UTF-8'); ?>"
                        <?php if (!empty($width)) echo ' width="' . $width . '"';?>
                        <?php if (!empty($height)) echo ' height="' . $height . '"';?> />
                    <?php if ($enablealt) echo "<h1>".$alt."</h1>"; ?>
                </a>
                <?php elseif ($target == 2) : ?>
                <?php // Open in a popup window ?>
                <a href="<?php echo $link; ?>" onclick="window.open(this.href, '',
							'toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=780,height=550');
							return false" title="<?php echo htmlspecialchars($item->name, ENT_QUOTES, 'UTF-8'); ?>">
                    <img src="<?php echo $baseurl . $imageurl; ?>"
                        alt="<?php echo htmlspecialchars($alt, ENT_QUOTES, 'UTF-8'); ?>"
                        <?php if (!empty($width)) echo ' width="' . $width . '"';?>
                        <?php if (!empty($height)) echo ' height="' . $height . '"';?> />
                    <?php if ($enablealt) echo "<h1>".$alt."</h1>"; ?>
                </a>
                <?php else : ?>
                <?php // Open in parent window ?>
                <a href="<?php echo $link; ?>"
                    title="<?php echo htmlspecialchars($item->name, ENT_QUOTES, 'UTF-8'); ?>">
                    <img src="<?php echo $baseurl . $imageurl; ?>"
                        alt="<?php echo htmlspecialchars($alt, ENT_QUOTES, 'UTF-8'); ?>"
                        <?php if (!empty($width)) echo ' width="' . $width . '"';?>
                        <?php if (!empty($height)) echo ' height="' . $height . '"';?> />
                    <?php if ($enablealt) echo "<h1>".$alt."</h1>"; ?>
                </a>
                <?php endif; ?>
                <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>
        <?php endforeach; ?>

    </div>
</div>