<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_articles_categories
 *
 * @copyright   (C) 2010 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;
use Joomla\Component\Content\Site\Helper\RouteHelper;
use Joomla\CMS\Factory;

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();

$wa->registerAndUseStyle(
    'mod_articles_categories.cuidadosMod-style', 
    'templates/puebla/html/mod_articles_categories/cuidadosMod/style.css'
);

$input  = $app->getInput();
$option = $input->getCmd('option');
$view   = $input->getCmd('view');
$id     = $input->getInt('id');

function obt_items($categoryId){
    $db = Factory::getDbo(); // ← Esto faltaba

    $query = $db->getQuery(true)
    ->select('*')
    ->from($db->quoteName('#__content'))
    ->where($db->quoteName('catid') . ' = ' . (int) $categoryId)
    ->where($db->quoteName('state') . ' = 1') 
    ->order($db->quoteName('created') . ' DESC');

    $db->setQuery($query);
    $items = $db->loadObjectList();

    return $items;
}


    ?>


<div id="catk2ModuleBox<?php echo $module->id; ?>" class="switchcat k2CatsBlock<?php if($params->get('moduleclass_sfx')) echo ' '.$params->get('moduleclass_sfx'); ?>">
	<ul class="uk-subnav uk-subnav-pill uk-margin-remove-bottom uk-padding-small" uk-switcher>
        
	<?php foreach ($list as $cat): ?>
		<li><a href="#"><?= $cat->title; ?></a></li>
	<?php endforeach; ?>

	</ul>
    <ul class="uk-switcher">
		<?php foreach ($list as $cat):
			$img = json_decode($cat->params);
            if (!empty($img->image)):

            $img = json_decode($cat->params);
            
            ?>

            
		<li class="">
			<div class="rejilla uk-padding-small">
			<div class="uk-margin-medium-top uk-margin-bottom" uk-grid>
				<div class="uk-width-1-2@l uk-width-1-2@m uk-width-1-3@s uk-width-1-1@xs catimg">
					<!-- <a href="/index.php/component/k2/itemlist/category/<?php echo $cat->id."-".$cat->alias?>"> -->
                    <img src="<?php echo $img->image; ?>" alt="Imagen de representación" />

					<!-- </a> -->
				</div>
				<div class="uk-width-1-2@l uk-width-1-2@m uk-width-2-3@s uk-width-1-1@xs catimg">
					<ul>
					<?php 
						$articles = obt_items($cat->id);
						// echo "<pre>".print_r($items, true)."</pre>";
						foreach ($articles as $article) { ?>
							<li>
								<a href="<?php echo $cat->path . "/" . $article->alias ?>">
								<!-- <a href="index.php/component/k2/item/<?= $item->id.'-'.$item->alias ?>"> -->
									<h1 class="title"><?= $article->title ?></h1>
									<span class="date">
										<?php echo $article->modified ?>
									</span>
								</a>
							</li>
							<?php
						}
					?>
					</ul>
				</div>
			</div>
			</div>
			<?php if( $params->get('seemorebutton') ): ?>
			<div class="uk-text-center uk-light uk-margin-medium">
				<!-- <a class="large-button bgc-c62038 bgch-c62038 c-fff uk-link-reset" href="/index.php/component/k2/itemlist/category/<?= $cat->id."-".$cat->alias ?>" title="Ver todos las publicaciones del apartado '<?= $cat->name ?>'"> -->
				<a class="large-button bgc-c62038 bgch-c62038 c-fff uk-link-reset" href="index.php/cuidados/<?= $cat->alias ?>" title="Ver todos las publicaciones del apartado '<?= $cat->name ?>'">
					<?= $params->get('seemoretext') ?>
				</a>
			</div>
			<?php endif; ?>
		</li>
		<?php endif; ?>
		<?php endforeach; ?>
	</ul>
	
</div>
