<?php
defined('_JEXEC') or die;

use Joomla\CMS\Router\Route;
use Joomla\Component\Content\Site\Helper\RouteHelper;

?>

<div class="uk-container">
    <h1 class="uk-text-center"><?= $this->category->title ?></h1>
    <div class="uk-grid-small uk-width-1-2@m " uk-grid>
        <?php if (!empty($this->items)) : ?>
        <?php foreach ($this->items as $item) : ?>
        <div>
            <?php $images = json_decode($item->images); ?>
            <a href="<?php echo Route::_(RouteHelper::getArticleRoute($item->slug, $item->catid)); ?>">
                <img src="<?php echo htmlspecialchars($images->image_intro, ENT_QUOTES, 'UTF-8'); ?>" alt="">
            </a>
            <spam>Modificado: <?php echo $item->modified; ?></span>

            <div class="itemcat-title">
                
                    <a href="<?php echo Route::_(RouteHelper::getArticleRoute($item->slug, $item->catid)); ?>">
                        <?php echo $item->title; ?>
                    </a>    
                
            </div>


        </div>
        <?php endforeach; ?>
        <?php else : ?>
        <p>No hay artículos disponibles en esta categoría.</p>
        <?php endif; ?>
    </div>
     <?php if (($this->params->def('show_pagination', 1) == 1 || ($this->params->get('show_pagination') == 2)) && ($this->pagination->pagesTotal > 1)) : ?>
        <div class="com-content-category-blog__navigation w-100">
            <?php if ($this->params->def('show_pagination_results', 1)) : ?>
                <p class="com-content-category-blog__counter counter float-md-end pt-3 pe-2">
                    <?php echo $this->pagination->getPagesCounter(); ?>
                </p>
            <?php endif; ?>
            <div class="com-content-category-blog__pagination">
                <?php echo $this->pagination->getPagesLinks(); ?>
            </div>
        </div>
    <?php endif; ?>
</div>

<style>
    .itemcat-title, 
    .itemcat-title a,
    .itemcat-title:hover, 
    .itemcat-title a:hover 
    {
    padding: 5% 0;
    font: 600 18px 'Corra Montserra';
    color: #5f1b2d;
    text-align: justify;
    line-height: 22px;
    text-decoration: none; /* Evita subrayado en enlaces */
    }

    .itemcat-desc, 
    .itemcat-desc a,
    .itemcat-desc:hover,
    .itemcat-desc a:hover,
    itemcat-desc span, 
    .itemcat-desc em
    {
    margin-top: 10px;
    font: 400 16px 'Corra Montserra';
    color: #6b6b6b !important;
    text-align: justify;
    }

    

</style>