<?php

/**
 * @package     Joomla.Site
 * @subpackage  com_content
 *
 * @copyright   (C) 2010 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\Component\Content\Site\Helper\RouteHelper;

$lang   = $this->getLanguage();
$user   = $this->getCurrentUser();
$groups = $user->getAuthorisedViewLevels();
$colors = ['color1', 'color2', 'color3', 'color4', 'color5', 'color6'];
$colorCount = count($colors);
$i = 0;

if ($this->maxLevel != 0 && count($this->children[$this->category->id]) > 0) : ?>
    <div class="uk-container">
        <div class="uk-child-width-1-2@s uk-child-width-1-4@m uk-flex uk-flex-center uk-text-center uk-grid-match " uk-grid>
            <?php foreach ($this->children[$this->category->id] as $id => $child) : ?>
                <?php // Check whether category access level allows access to subcategories. 
                ?>
                <?php if (in_array($child->access, $groups)) : ?>

                    <?php
                    //$images = json_decode($child->getParams()->get('image'), true);
                    //$image  = isset($images['image']) && !empty($images['image']) ? $images['image'] : null;
                    $params = is_string($child->params) ? json_decode($child->params) : null;
                    $image = isset($params->image) && !empty($params->image) ? $params->image : 'path/to/default.jpg';


                    if (!$image) {
                        $params = json_decode($child->params);
                        $image = isset($params->image) && !empty($params->image) ? $params->image : 'path/to/default.jpg';
                    }


                    $colorClass = $colors[$i % $colorCount];
                    $i++;
                    ?>


                    <?php if ($this->params->get('show_empty_categories') || $child->numitems || count($child->getChildren())) : ?>
                        <div class="com-content-category-blog__child">
                            <?php if ($lang->isRtl()) : ?>


                                <div class="uk-margin-left uk-padding-remove-left boder uk-card-small <?php echo $colorClass; ?>">
                                    <h3 class="page-header item-title">
                                        <?php if ($this->params->get('show_cat_num_articles', 1)) : ?>
                                            <span class="badge bg-info tip">
                                                <?php echo $child->getNumItems(true); ?>
                                            </span>
                                        <?php endif; ?>
                                        <a href="<?php echo Route::_(RouteHelper::getCategoryRoute($child->id, $child->language)); ?>">
                                            <?php echo $this->escape($child->title); ?></a>

                                        <?php if ($this->maxLevel > 1 && count($child->getChildren()) > 0) : ?>
                                            <a href="#category-<?php echo $child->id; ?>" data-bs-toggle="collapse" class="btn btn-sm float-end" aria-label="<?php echo Text::_('JGLOBAL_EXPAND_CATEGORIES'); ?>"><span class="icon-plus" aria-hidden="true"></span></a>
                                        <?php endif; ?>
                                    </h3>
                                </div>



                            <?php else : ?>

                                <div class="uk-margin-left uk-padding-remove-left boder uk-card-small <?php echo $colorClass; ?>">

                                    <h3 class="page-header item-title"><a href="<?php echo Route::_(RouteHelper::getCategoryRoute($child->id, $child->language)); ?>">

                                            <?php if (!empty($image)) : ?>
                                                <div class="filtro-icons uk-padding-small uk-padding-remove-bottom">
                                                    <img src="<?php echo htmlspecialchars($image); ?>" alt="<?php echo htmlspecialchars($child->title); ?>" style="width: 90px; height: 100%; object-fit: cover;">
                                                </div>
                                            <?php endif; ?>

                                            <div class="uk-card-body">
                                                <h4 class="c-fff">
                                                    <?php echo $this->escape($child->title); ?></h4>
                                            </div>


                                        </a>
                                        <?php if ($this->params->get('show_cat_num_articles', 1)) : ?>

                                            <span class="badge bg-info">
                                                <?php echo Text::_('COM_CONTENT_NUM_ITEMS'); ?>&nbsp;
                                                <?php echo $child->getNumItems(true); ?>
                                            </span>
                                        <?php endif; ?>

                                        <?php if ($this->maxLevel > 1 && count($child->getChildren()) > 0) : ?>
                                            <a href="#category-<?php echo $child->id; ?>" data-bs-toggle="collapse" class="btn btn-sm float-end" aria-label="<?php echo Text::_('JGLOBAL_EXPAND_CATEGORIES'); ?>"><span class="icon-plus" aria-hidden="true"></span></a>
                                        <?php endif; ?>
                                    </h3>

                                </div>

                            <?php endif; ?>

                            <?php if ($this->params->get('show_subcat_desc') == 1) : ?>
                                <?php if ($child->description) : ?>
                                    <div class="com-content-category-blog__description category-desc">
                                        <?php echo HTMLHelper::_('content.prepare', $child->description, '', 'com_content.category'); ?>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>

                            <?php if ($this->maxLevel > 1 && count($child->getChildren()) > 0) : ?>
                                <div class="com-content-category-blog__children collapse fade" id="category-<?php echo $child->id; ?>">
                                    <?php
                                    $this->children[$child->id] = $child->getChildren();
                                    $this->category = $child;
                                    $this->maxLevel--;
                                    echo $this->loadTemplate('children');
                                    $this->category = $child->getParent();
                                    $this->maxLevel++;
                                    ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
    </div>
<?php endif;
