<?php
/**
 * @package     Joomla.Site
 * @subpackage  com_content
 * @copyright   (C) 2006 Open Source Matters, Inc.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Layout\LayoutHelper;

// Aplicación
$app = Factory::getApplication();

// Preparar la descripción con plugins
$this->category->text = $this->category->description;
$app->triggerEvent('onContentPrepare', [$this->category->extension . '.categories', &$this->category, &$this->params, 0]);
$this->category->description = $this->category->text;

// Eventos para insertar contenido extra
$afterDisplayTitle    = trim(implode("\n", $app->triggerEvent('onContentAfterTitle', [$this->category->extension . '.categories', &$this->category, &$this->params, 0])));
$beforeDisplayContent = trim(implode("\n", $app->triggerEvent('onContentBeforeDisplay', [$this->category->extension . '.categories', &$this->category, &$this->params, 0])));
$afterDisplayContent  = trim(implode("\n", $app->triggerEvent('onContentAfterDisplay', [$this->category->extension . '.categories', &$this->category, &$this->params, 0])));

// Decide la etiqueta para el título principal según configuración
$htag = $this->params->get('show_page_heading') ? 'h2' : 'h1';

// Variables principales de categoría padre
$parent = $this->category;
$title = $parent->title;
$description = $parent->description;

// Obtener imagen desde parámetros de la categoría
$parentParams = new Joomla\Registry\Registry($parent->params);
$image = $parentParams->get('image');
?>

<div class="com-content-category-document blog">

    <!-- Título de la página -->
    <?php if ($this->params->get('show_page_heading')) : ?>
        <header class="page-header">
            <h1><?php echo $this->escape($this->params->get('page_heading')); ?></h1>
        </header>
    <?php endif; ?>

    <!-- Bloque principal con imagen y título/descripción -->
    <section class="uk-margin-medium-top">
        <div class="uk-card uk-card-body uk-padding-remove-left uk-padding-remove-right">
            <div class="uk-grid-small uk-flex-middle uk-flex-center uk-text-center" uk-grid>
                <?php if (!empty($image)) : ?>
                    <img src="<?php echo htmlspecialchars($image); ?>" alt="<?php echo htmlspecialchars($title); ?>" style="max-width:100px; height:auto;">
                <?php endif; ?>
                <div class="">
                    <h2 class="uk-margin-top uk-margin-remove-bottom"><?php echo htmlspecialchars($title); ?></h2>
                </div>
            </div>
            <?php if (!empty($description)) : ?>
                <div class="uk-margin-small-top">
                    <p><?php echo $description; ?></p>
                </div>
            <?php endif; ?>
        </div>
    </section>

    <!-- Mostrar subcategorías si hay -->
    <?php if ($this->maxLevel != 0 && !empty($this->children[$this->category->id])) : ?>
        <section class="com-content-category-document__children cat-children uk-margin-large-bottom">
            <?php echo $this->loadTemplate('children'); ?>
        </section>
    <?php endif; ?>





    <!-- Descripción detallada y contenido adicional -->
    <?php if ($beforeDisplayContent || $afterDisplayContent || $this->params->get('show_description', 1) || $this->params->def('show_description_image', 1)) : ?>
        <div class="category-desc clearfix">
            <?php if ($this->params->get('show_description_image') && $this->category->getParams()->get('image')) : ?>
                <?php echo LayoutHelper::render(
                    'joomla.html.image',
                    [
                        'src' => $this->category->getParams()->get('image'),
                        'alt' => $this->category->getParams()->get('image_alt') ?: $this->category->title,
                    ]
                ); ?>
            <?php endif; ?>

            <?php echo $beforeDisplayContent; ?>

            <?php if ($this->params->get('show_description') && $this->category->description) : ?>
                <?php echo HTMLHelper::_('content.prepare', $this->category->description, '', 'com_content.category'); ?>
            <?php endif; ?>

            <?php echo $afterDisplayContent; ?>
        </div>
    <?php endif; ?>



    <!-- Artículos destacados -->
    <?php if (!empty($this->lead_items)) : ?>
        <div class="com-content-category-document__items blog-items items-leading <?php echo $this->params->get('blog_class_leading'); ?>">
            <?php foreach ($this->lead_items as &$item) : ?>
                <article class="com-content-category-document__item blog-item">
                    <?php
                    $this->item = &$item;
                    echo $this->loadTemplate('item');
                    ?>
                </article>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <!-- Artículos intro -->
    <?php if (!empty($this->intro_items)) : ?>
        <?php
        $blogClass = $this->params->get('blog_class', '');
        if ((int) $this->params->get('num_columns') > 1) {
            $blogClass .= (int) $this->params->get('multi_column_order', 0) === 0 ? ' masonry-' : ' columns-';
            $blogClass .= (int) $this->params->get('num_columns');
        }
        ?>
        <div class="com-content-category-document__items blog-items<?php echo $blogClass; ?>">
            <?php foreach ($this->intro_items as &$item) : ?>
                <article class="com-content-category-document__item blog-item">
                    <?php
                    $this->item = &$item;
                    echo $this->loadTemplate('item');
                    ?>
                </article>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <!-- Más enlaces -->
    <?php if (!empty($this->link_items)) : ?>
        <div class="items-more">
            <?php echo $this->loadTemplate('links'); ?>
        </div>
    <?php endif; ?>

  

    <!-- Paginación -->
    <?php if (($this->params->def('show_pagination', 1) == 1 || $this->params->get('show_pagination') == 2) && ($this->pagination->pagesTotal > 1)) : ?>
        <nav class="com-content-category-document__navigation w-100" aria-label="<?php echo Text::_('JGLOBAL_PAGINATION'); ?>">
            <?php if ($this->params->def('show_pagination_results', 1)) : ?>
                <p class="com-content-category-document__counter counter float-md-end pt-3 pe-2">
                    <?php echo $this->pagination->getPagesCounter(); ?>
                </p>
            <?php endif; ?>
            <div class="com-content-category-document__pagination">
                <?php echo $this->pagination->getPagesLinks(); ?>
            </div>
        </nav>
    <?php endif; ?>
</div>
