<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_articles
 *
 * @copyright   (C) 2024 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

if ($params->get('articles_layout') == 1) {
    $gridCols = 'grid-cols-' . $params->get('layout_columns');
}
$doc = Factory::getDocument();
$doc->addStyleSheet(Uri::base() . 'modules/mod_articles/tmpl/slider/css/style.css');
?>

<div uk-slider>
    <div class="uk-position-relative uk-visible-toggle uk-light" tabindex="-1">
        <ul class="uk-slider-items uk-child-width-1-1">
            <?php foreach ($items as $item) : ?>
                <?php  
                    $img  = json_decode($item->images);
                    $urls = json_decode($item->urls);
                ?>
                <li>
                    <a href="<?= htmlspecialchars($urls->urla) ?>" target="_blank" tabindex="-1">
                        <img src="<?= htmlspecialchars($img->image_intro) ?>" alt="<?= htmlspecialchars($item->title) ?>">
                    </a>
                </li>
            <?php endforeach; ?>
        </ul>
    </div>
    <ul class="uk-slider-nav uk-dotnav uk-flex-center uk-margin"></ul>
</div>