<?php
defined('_JEXEC') or die;

use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Layout\FileLayout;

?>

<div class="uk-grid uk-child-width-1-3@m uk-grid-match" uk-grid>
    <?php foreach ($list as $item) : ?>
    <div>
        <div class="uk-card uk-card-default uk-height-1-1">
            <?php if ($params->get('show_image') && !empty($item->imageSrc)) : ?>
            <div class="uk-card-media-top">
                <img src="<?= htmlspecialchars($item->imageSrc, ENT_QUOTES, 'UTF-8') ?>"
                    alt="<?= htmlspecialchars($item->title, ENT_QUOTES, 'UTF-8') ?>">
            </div>
            <?php endif; ?>

            <div class="uk-card-body">
                <h3 class="uk-card-title">
                    <a class="uk-link-heading" href="<?= htmlspecialchars($item->link, ENT_QUOTES, 'UTF-8') ?>">
                        <?= htmlspecialchars($item->title); ?>
                    </a>
                </h3>

                <?php if (!empty($item->displayIntrotext)) : ?>
                <p><?= $item->displayIntrotext; ?></p>
                <?php endif; ?>

                <a href="<?= htmlspecialchars($item->link, ENT_QUOTES, 'UTF-8') ?>" class="uk-button uk-button-primary">
                    Leer más
                </a>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
</div>