<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  System.autosetaccess
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\CMSPlugin;

class PlgSystemAutosetaccess extends CMSPlugin
{
    protected $app;

    public function onContentBeforeSave($context, $article, $isNew)
    {
        // Solo aplica a artículos nuevos
        if ($context !== 'com_content.article' || !$isNew) {
            return true;
        }

        $user = Factory::getApplication()->getIdentity();
        $userGroups = $user->groups; // IDs de grupos del usuario

        // Default: Public
        $assignedAccess = 1;

        // Mapa explícito: Grupo de usuario -> Nivel de acceso
        $groupToAccess = [
            10 => 7, 
            11 => 8, 
            12=>9
            // Agrega aquí más grupos si los necesitas
        ];

        foreach ($userGroups as $gid) {
            if (isset($groupToAccess[$gid])) {
                $assignedAccess = $groupToAccess[$gid];
                break; 
            }
        }

        $article->access = $assignedAccess;

        return true;
    }
}