<?php
/**
 * Módulo de Subcategorías en Select:
 * Muestra subcategorías en un <select> y redirige a la vista de artículo 
 * (el primer artículo de la subcategoría) al seleccionar una opción, abriéndola en una nueva pestaña.
 */
defined('_JEXEC') or die;

use Joomla\CMS\Router\Route;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

$doc = Factory::getDocument();
$doc->addStyleSheet(Uri::base() . 'modules/mod_municipio/css/style.css');
$iconPath = Uri::base() . 'modules/mod_accordion/icons/';

if ($module->showtitle) {
    echo '<h2 class="uk-text-center uk-margin-bottom">' . htmlspecialchars($module->title, ENT_QUOTES, 'UTF-8') . '</h2>';
}

if (empty($categories)) {
    echo '<p>No hay contenido disponible.</p>';
    return;
}

// --------------------------------------------------------------------------
//  FUNCIÓN PARA RENDERIZAR SUBCATEGORÍAS Y REDIRIGIR AL PRIMER ARTÍCULO
// --------------------------------------------------------------------------

/**
 * Función que renderiza las subcategorías en un select y adjunta el JS para la navegación.
 *
 * @param array $subcategories
 * @return void
 */
function renderSelectSubcategories($subcategories)
{
    $doc = Factory::getDocument();

    if (empty($subcategories)) {
        return;
    }

   echo '<div class="uk-margin uk-text-center">';
echo '  <div class="uk-inline uk-width-medium">'; // contenedor para el icono
echo '      <select class="uk-select ssel uk-padding-small" id="subcategory-select-nav">';
echo '          <option class="uk-text-center" value="">Encuentra <b>tu municipio</b></option>';
foreach ($subcategories as $category) {

    $articleLink = '';

    if (!empty($category->articles[0])) {
        $article = $category->articles[0];
        $articleLink = Route::_('./municipio?' . 'catid=' . (int) $article->catid);
    }

    echo '          <option class="uk-text-center"value="' . htmlspecialchars($articleLink, ENT_QUOTES, 'UTF-8') . '">';
    echo htmlspecialchars($category->title, ENT_QUOTES, 'UTF-8');
    echo '</option>';
}
echo '      </select>';
echo '      <span class="uk-form-icon uk-form-icon-flip idown" uk-icon="icon: triangle-down; ratio: 1.5"></span>';
echo '  </div>';
echo '</div>';
//echo '<div style="background: linear-gradient(180deg, rgba(242, 242, 242, 1) 1%, rgba(255, 255, 255, 1) 11%);
  //  padding: 50px;"></div>';



    // *** EL JAVASCRIPT SE MANTIENE IGUAL ***
    $script = <<<JS
document.addEventListener('DOMContentLoaded', function() {
    const selectElement = document.getElementById('subcategory-select-nav');
    
    // Evento de cambio en el select
    selectElement.addEventListener('change', function() {
        const selectedUrl = this.value;

        if (selectedUrl) {
            // Abrimos la URL en una nueva pestaña (target="_blank")
            window.open(selectedUrl, '_parent');
            
            // OPCIONAL: Devolvemos el select a la opción "---" después de la redirección
            this.selectedIndex = 0;
        }
    });
});
JS;
    $doc->addScriptDeclaration($script);
}

// --------------------------------------------------------------------------
//  LÓGICA PRINCIPAL DEL MÓDULO
// --------------------------------------------------------------------------

// Llama a la función con las subcategorías del nivel más alto
if (!empty($categories[0]->children)) {
    renderSelectSubcategories($categories[0]->children);
}

?>