<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;

class ModCategoriaaJerarquiaHelper
{
    public static function getCategories($rootId = 1)
    {
        $db = Factory::getDbo();

        // Obtener todas las categorías publicadas de com_content
        $query = $db->getQuery(true)
            ->select('id, parent_id, title, lft')
            ->from($db->quoteName('#__categories'))
            ->where($db->quoteName('extension') . ' = ' . $db->quote('com_content'))
            ->where($db->quoteName('published') . ' = 1')
            ->order('lft ASC');
        $db->setQuery($query);

        $items = $db->loadObjectList();

        // Crear índice de categorías
        $categories = [];
        foreach ($items as $item) {
            $item->children = [];
            $categories[$item->id] = $item;
        }

        // Obtener todos los artículos y agruparlos por categoría
        $articles = self::getArticles();
        foreach ($articles as $article) {
            if (isset($categories[$article->catid])) {
                $categories[$article->catid]->articles[] = $article;
            }
        }

        // Construir jerarquía
        $tree = [];
        foreach ($categories as $id => $cat) {
            if ($cat->parent_id > 1 && isset($categories[$cat->parent_id])) {
                $categories[$cat->parent_id]->children[] = $cat;
            }
        }

        // Devolver el nodo raíz
        return isset($categories[$rootId]) ? [$categories[$rootId]] : [];
    }

    protected static function getArticles()
    {
        $db = Factory::getDbo();

        // Obtener todos los artículos publicados
        $query = $db->getQuery(true)
            ->select('id, title, catid, urls')
            ->from($db->quoteName('#__content'))
            ->where($db->quoteName('state') . ' = 1')
            ->order('title ASC');
        $db->setQuery($query);

        return $db->loadObjectList();
    }
}