<?php
defined('_JEXEC') or die;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
$doc = Factory::getDocument();
$doc->addStyleSheet(Uri::base() . 'modules/mod_categoria_detalle/css/style.css');

if (!$catData) :

?>
<p>No se encontró la categoría.</p>
<?php else : ?>
<div class="uk-padding-small">

    <div class="municipio-header" style="background-image:url('/images/banners/banner_back_municipio.jpg');">

        <?php if (!empty($catData->image)) : ?>
        <div class="municipio-escudo">
            <img src="<?php echo htmlspecialchars($catData->image, ENT_QUOTES, 'UTF-8'); ?>"
                alt="<?php echo htmlspecialchars($catData->title, ENT_QUOTES, 'UTF-8'); ?>">
        </div>
        <?php endif; ?>

        <div class="municipio-nombre">
            <h2><?php echo htmlspecialchars($catData->title, ENT_QUOTES, 'UTF-8'); ?></h2>
        </div>

        <div class="municipio-mapa"></div>

        <div class="municipio-derecha uk-text-center">
            <div class="texto-selector">
                <p class="titulo">Encuentra<br><strong>tu municipio</strong></p>
                <a href="/" class="select-button">
                    Selecciona ... <span class="arrow"></span>
                </a>
            </div>
        </div>

    </div>
</div>
<?php endif; ?>