<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\Database\DatabaseInterface;

class ModCategoriaDetalleHelper
{
    public static function getCategoria()
    {
        $app = Factory::getApplication();
        $input = $app->input;
        $catid = (int) $input->get('catid', 0, 'INT');

        if (!$catid) {
            return null;
        }

        /** @var DatabaseInterface $db */
        $db = Factory::getContainer()->get('DatabaseDriver');

        $query = $db->getQuery(true)
            ->select($db->quoteName(['id', 'title', 'params']))
            ->from($db->quoteName('#__categories'))
            ->where($db->quoteName('id') . ' = ' . (int) $catid);

        $db->setQuery($query);
        $category = $db->loadObject();

        if ($category) {
            // Decodificar parámetros para obtener la imagen
            $params = json_decode($category->params);
            $category->image = $params->image ?? '';
        }

        return $category;
    }
}