<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;

class ModCategoriasJerarquiaHelper
{
    /**
     * Obtiene la jerarquía de categorías y sus artículos.
     * Los artículos se devuelven agrupados por Concepto, Año y Trimestre.
     */
    public static function getCategories($rootId = 1, $municipioCatId = null)
    {
    
        $db = Factory::getDbo();

        //  Obtiene las categorías publicadas
        $query = $db->getQuery(true)
            ->select('id, parent_id, title, lft,params,description')
            ->from($db->quoteName('#__categories'))
            ->where($db->quoteName('extension') . ' = ' . $db->quote('com_content'))
            ->where($db->quoteName('published') . ' = 1')
            ->order('lft ASC');
        $db->setQuery($query);
        $items = $db->loadObjectList();

        //índice de categorías
        $categories = [];
        foreach ($items as $item) {
            $item->children = [];
            $item->articles = []; 
            $item->groups = []; 
            $categories[$item->id] = $item;
        }

        //  Obtiene y agrupa todos los artículos
        $groupedArticles = self::getArticles($municipioCatId); 
        
        // Asignar los grupos (Concepto > Año > Trimestre) a sus categorías principales
        foreach ($groupedArticles as $article) {
            if (isset($categories[$article->catid])) {
                
               
                $concepto = $article->field_concepto_value ?? 'Sin Concepto Asignado';
                $year     = $article->field_year_value ?? 'Sin Año Asignado';
                $quarter  = $article->field_quarter_value ?? 'Sin Trimestre Asignado';

                // nivel 
                if (!isset($categories[$article->catid]->groups[$concepto])) {
                    $categories[$article->catid]->groups[$concepto] = [];
                }
                if (!isset($categories[$article->catid]->groups[$concepto][$year])) {
                    $categories[$article->catid]->groups[$concepto][$year] = [];
                }
                if (!isset($categories[$article->catid]->groups[$concepto][$year][$quarter])) {
                    $categories[$article->catid]->groups[$concepto][$year][$quarter] = [];
                }

                // asignacion al trimestre correspondiente
                $categories[$article->catid]->groups[$concepto][$year][$quarter][] = $article;
            }
        }

        // jerarquía de categorías
        foreach ($categories as $id => $cat) {
            if ($cat->parent_id > 1 && isset($categories[$cat->parent_id])) {
                $categories[$cat->parent_id]->children[] = $cat;
            }
        }



        // 🔸 Obtener todos los años disponibles (categorías hijas de la categoría "Años")
$queryYears = $db->getQuery(true)
    ->select('title')
    ->from($db->quoteName('#__categories'))
    ->where($db->quoteName('parent_id') . ' = ' . $db->quote('263')) // cambia esto por el ID real
    ->where($db->quoteName('published') . ' = 1')
    ->order('title DESC');

$db->setQuery($queryYears);
$allYears = $db->loadColumn();

// Guardamos en la raíz para usar en el JS
if (isset($categories[$rootId])) {
    $categories[$rootId]->allYears = $allYears;
}




        return isset($categories[$rootId]) ? [$categories[$rootId]] : [];
    }

    /**
     * Obtiene los artículos, uniendo los campos de Municipio, Concepto, Año y Trimestre.
     */
    protected static function getArticles($municipioCatId = null)
    {
        $db = Factory::getDbo();

        $query = $db->getQuery(true)
            ->select('a.id, a.title, a.catid, a.urls') 
            
            ->select('b_mun.value AS field_municipio_id')
            ->select('b_conc.value AS field_concepto_id')
            ->select('b_year.value AS field_year_id') 
            ->select('b_qtr.value AS field_quarter_id') 
            
           
            ->select('COALESCE(c_conc.title, NULL) AS field_concepto_value') 
            ->select('COALESCE(c_year.title, NULL) AS field_year_value')      
            ->select('COALESCE(c_qtr.title, NULL) AS field_quarter_value')     
            
            ->from($db->quoteName('#__content', 'a'))
            
            // INNER JOIN para  MUNICIPIO (field_id = 4)
            ->innerJoin(
                $db->quoteName('#__fields_values', 'b_mun') . ' ON (' .
                $db->quoteName('a.id') . ' = ' . $db->quoteName('b_mun.item_id') . ' AND ' .
                $db->quoteName('b_mun.field_id') . ' = ' . $db->quote('1') .
                ')'
            )
            
           
            
            //  LEFT JOIN para  CONCEPTO (field_id = 9) - solo obtiene  el ID
            ->leftJoin(
                $db->quoteName('#__fields_values', 'b_conc') . ' ON (' .
                $db->quoteName('a.id') . ' = ' . $db->quoteName('b_conc.item_id') . ' AND ' .
                $db->quoteName('b_conc.field_id') . ' = ' . $db->quote('4') . 
                ')'
            )
            
            //  LEFT JOIN para titulo del concepto 
            ->leftJoin(
                $db->quoteName('#__categories', 'c_conc') . ' ON (' .
                $db->quoteName('b_conc.value') . ' = ' . $db->quoteName('c_conc.id') .
                ')'
            )
            
            //  LEFT JOIN para  AÑO (field_id = 1)
            ->leftJoin(
                $db->quoteName('#__fields_values', 'b_year') . ' ON (' .
                $db->quoteName('a.id') . ' = ' . $db->quoteName('b_year.item_id') . ' AND ' .
                $db->quoteName('b_year.field_id') . ' = ' . $db->quote('2') .
                ')'
            )
            
            //  LEFT JOIN para titulo del año 
            ->leftJoin(
                $db->quoteName('#__categories', 'c_year') . ' ON (' .
                $db->quoteName('b_year.value') . ' = ' . $db->quoteName('c_year.id') .
                ')'
            )
            
            //  LEFT JOIN para  TRIMESTRE (field_id = 2) 
            ->leftJoin(
                $db->quoteName('#__fields_values', 'b_qtr') . ' ON (' .
                $db->quoteName('a.id') . ' = ' . $db->quoteName('b_qtr.item_id') . ' AND ' .
                $db->quoteName('b_qtr.field_id') . ' = ' . $db->quote('3') .
                ')'
            )
            
            //  LEFT JOIN para titulo del trimestre
            ->leftJoin(
                $db->quoteName('#__categories', 'c_qtr') . ' ON (' .
                $db->quoteName('b_qtr.value') . ' = ' . $db->quoteName('c_qtr.id') .
                ')'
            )
            
            ->where($db->quoteName('a.state') . ' = 1');
            
        // FILTRO por el Municipio
        if (!is_null($municipioCatId) && $municipioCatId > 0) {
            $query->where($db->quoteName('b_mun.value') . ' = ' . $db->quote($municipioCatId));
        }

        // Ordenamos por Concepto ASC, Año DESC, luego Trimestre DESC
        $query->order('field_concepto_value ASC, field_year_value DESC, field_quarter_value DESC, a.title ASC');

        $db->setQuery($query);

        return $db->loadObjectList();
    }
}