<?php
/**
 * Archivo principal: mod_accordion/mod_accordion.php
 */
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;

// Incluir el Helper. (Asegúrate de que la ruta sea correcta)
require_once __DIR__ . '/src/AccordionHelper.php';

// 1. Obtener el ID de la categoría raíz del acordeón (parámetro del módulo)
$parentId = (int) $params->get('parent_id', 1);

// 2. Obtener el ID de la categoría actual (el municipio) desde la URL
$app = Factory::getApplication();
// 🚨 CAMBIO AQUÍ: Busca el parámetro 'catid' en lugar de 'id'
$municipioCatId = $app->input->getInt('catid', 0); 

// 3. Preparar el ID para el filtro (solo si es un ID válido)
$filterId = $municipioCatId > 0 ? $municipioCatId : null;

// 4. Llamar al Helper y pasar el ID para el filtrado
$categories = ModCategoriasJerarquiaHelper::getCategories($parentId, $filterId);

// 5. Incluir el template (layout)
require ModuleHelper::getLayoutPath('mod_accordion', $params->get('layout', 'default'));