<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\Component\Content\Site\Helper\RouteHelper;

require_once __DIR__ . '/src/AccordionHelper.php';

$catid = (int) ($_GET['catid'] ?? 0);
if (!$catid) exit;

$children = ModAccordionHelper::getCategoryChildren($catid);

if (empty($children)) {
    echo '<p>No hay subcategorías disponibles.</p>';
    return;
}

echo '<div class="uk-grid-small uk-child-width-1-2@s uk-child-width-1-3@m" uk-grid>';

foreach ($children as $child) {
    $params = json_decode($child->params);
    $image = !empty($params->image) ? $params->image : '/images/placeholder.png';

    echo '<div>';
    echo '<div class="uk-card uk-card-default uk-card-hover uk-border-rounded">';
    echo '<div class="uk-card-media-top">';
    echo '<img src="' . htmlspecialchars($image) . '" alt="' . htmlspecialchars($child->title) . '" style="width:100%;height:150px;object-fit:cover;">';
    echo '</div>';
    echo '<div class="uk-card-body">';
    echo '<h4>' . htmlspecialchars($child->title) . '</h4>';

    if (!empty($child->articles)) {
        echo '<ul class="uk-list uk-list-divider">';
        foreach ($child->articles as $article) {
            $url = Route::_(RouteHelper::getArticleRoute($article->id, $article->catid));
            echo '<li><a href="' . $url . '" target="_blank">' . htmlspecialchars($article->title) . '</a></li>';
        }
        echo '</ul>';
    }

    echo '</div></div></div>';
}

echo '</div>';