document.addEventListener("DOMContentLoaded", function () {
  // === CLONAR MÓDULO SEARCH ===
  const searchHTML = document.querySelector('#search-module > *');
  const searchDesktop = document.getElementById('search-position-desktop');
  const searchMobile = document.getElementById('search-position-mobile');

  if (searchHTML) {
    // --- Escritorio
    if (searchDesktop) {
      const cloneDesk = searchHTML.cloneNode(true);
      fixSearchIDsAndClasses(cloneDesk, 'desk');
      searchDesktop.appendChild(cloneDesk);

      setTimeout(() => {
        const boxDesk = searchDesktop.querySelector('.custom-search');
        if (boxDesk) initSearchToggle(boxDesk);
      }, 50);
    }

    // --- Móvil
    if (searchMobile) {
      const cloneMobile = searchHTML.cloneNode(true);
      fixSearchIDsAndClasses(cloneMobile, 'mobile');
      searchMobile.appendChild(cloneMobile);

      setTimeout(() => {
        const boxMobile = searchMobile.querySelector('.custom-search');
        if (boxMobile) initSearchToggle(boxMobile);
      }, 50);
    }
  }

  // === CLONAR MÓDULO ACCESIBILIDAD ===
  const accHTML = document.querySelector('#accesibilidad-module > *');
  const accDesktop = document.getElementById('accesibilidad-position-desktop');
  const accMobile = document.getElementById('accesibilidad-position-mobile');

  if (accHTML) {
    if (accDesktop) accDesktop.appendChild(accHTML.cloneNode(true));
    if (accMobile) accMobile.appendChild(accHTML.cloneNode(true));
  }

  // === FUNCIONES ===

  // Inicializa toggle de buscador
  function initSearchToggle(searchBox) {
    const toggleBtn = searchBox.querySelector('.search-toggle');
    const input = searchBox.querySelector('.search-input');

    if (!toggleBtn || !input) return;

    toggleBtn.addEventListener('click', (e) => {
      e.stopPropagation();
      searchBox.classList.toggle('expanded');
      if (searchBox.classList.contains('expanded')) {
        input.focus();
      } else {
        input.value = '';
      }
    });

    // Cierra si haces clic fuera
    document.addEventListener('click', (e) => {
      if (!searchBox.contains(e.target) && input.value.trim() === '') {
        searchBox.classList.remove('expanded');
      }
    });
  }

  // Reasigna IDs y clases para evitar duplicados
  function fixSearchIDsAndClasses(clone, tipo) {
    const input = clone.querySelector('#mod-search');
    const btn = clone.querySelector('#search-btn');

    if (input) {
      input.id = tipo === 'mobile' ? 'mod-search-mobile' : 'mod-search-desk';
      input.classList.add('search-input');
    }

    if (btn) {
      btn.id = tipo === 'mobile' ? 'search-btn-mobile' : 'search-btn-desk';
      btn.classList.add('search-toggle');
    }
  }

  // === ACCESIBILIDAD ===
  const accIcons = document.querySelectorAll(".img-access");
  const waitForBtn = setInterval(() => {
    const accessBtn = document.querySelector("._access-icon");
    if (accessBtn) {
      clearInterval(waitForBtn);
      accIcons.forEach(icon => {
        icon.addEventListener("click", () => {
          accessBtn.click();
        });
      });
      //  }
      // }, 300);
      //
      // === ACCESIBILIDAD:  navegación con teclado ===
      const accessItems = document.querySelectorAll("._access-menu ul li, ._menu-close-btn, ._menu-reset-btn");

      accessItems.forEach(item => {
        item.setAttribute("tabindex", "0");
        item.setAttribute("role", "button");
        item.setAttribute("aria-pressed", "false");

        // Activar con ENTER o SPACE
        item.addEventListener("keydown", e => {
          if (e.key === "Enter" || e.key === " ") {
            e.preventDefault();
            item.click();
          }
        });
      });
    }
  }, 300);

  function addTab(elements) {
    elements.forEach(function (content) {
      var ps = content.querySelectorAll('p, h1, h2, h3, h4, h5, h6, center,li, span, spam');
      ps.forEach(function (p) { if (p.tabIndex == -1) p.tabIndex = 0 });
    });
  }
  // Al final de tu DOMContentLoaded
  const contenidos = document.querySelectorAll('.contenido-principal, main, .container, .uk-container ');
  addTab(contenidos);

  //
  // === SCROLL A #list_casa ===
  function scrollToCasa(e) {
    e.preventDefault();
    const destino = document.querySelector('#list_categorias');
    if (destino) {
      window.scrollTo({
        top: destino.offsetTop - 200,
        behavior: 'smooth'
      });
    }
  }

  // Selecciona todos los enlaces con href="#list_casa"
  const linksCasa = document.querySelectorAll('a[href="#list_categorias"]');
  linksCasa.forEach(link => {
    link.addEventListener('click', scrollToCasa);
  });
  //
});
