<?php
/**
 * @package     Custom Banner Slider (Joomla 5 compatible)
 * @author      Adaptado por ChatGPT
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\Component\Banners\Site\Helper\BannerHelper;

$doc = Factory::getDocument();
$baseurl = Uri::base(true);

// 🔹 Cargar librerías externas (Slick + jQuery)
$doc->addScript('https://ajax.googleapis.com/ajax/libs/jquery/2.1.4/jquery.min.js');
$doc->addScript(Uri::root(true) . '/templates/puebla/html/' . $module->module . '/js/slick.js');
$doc->addScript(Uri::root(true) . '/templates/puebla/html/' . $module->module . '/js/scripts.js');
$doc->addStyleSheet(Uri::root(true) . '/templates/puebla/html/' . $module->module . '/css/slick.css');
$doc->addStyleSheet(Uri::root(true) . '/templates/puebla/html/' . $module->module . '/css/style.css');
$doc->addStyleSheet(Uri::root(true) . '/templates/puebla/html/' . $module->module . '/css/font-awesome-animation.min.css');
?>

<div class="slider responsive <?php echo htmlspecialchars($moduleclass_sfx, ENT_QUOTES, 'UTF-8'); ?>">
    <?php foreach ($list as $item) : ?>
    <div class="banneritem">
        <?php
            $link = Route::_('index.php?option=com_banners&task=click&id=' . (int) $item->id);

            if ($item->type == 1) :
                // 🔹 Banner de texto
                echo str_replace(
                    ['{CLICKURL}', '{NAME}'],
                    [$link, $item->name],
                    $item->custombannercode
                );
            else:
                $imageurl = $item->params->get('imageurl');
                $width = $item->params->get('width');
                $height = $item->params->get('height');

                if (BannerHelper::isImage($imageurl)) :
                    $alt = $item->params->get('alt') ?: $item->name ?: 'Banner';
                    $imgTag = '<img src="' . Uri::root() . ltrim($imageurl, '/') . '" alt="' . htmlspecialchars($alt, ENT_QUOTES, 'UTF-8') . '"';
                    if (!empty($width)) $imgTag .= ' width="' . (int)$width . '"';
                    if (!empty($height)) $imgTag .= ' height="' . (int)$height . '"';
                    $imgTag .= ' />';

                    if ($item->clickurl) :
                        $target = (int)$params->get('target', 1);
                        $linkAttr = 'title="' . htmlspecialchars($item->name, ENT_QUOTES, 'UTF-8') . '"';

                        if ($target === 1) :
                            echo '<a href="' . $link . '" target="_blank" ' . $linkAttr . '>' . $imgTag . '</a>';
                        elseif ($target === 2) :
                            echo '<a href="' . $link . '" onclick="window.open(this.href,\'\',\'toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=780,height=550\');return false" ' . $linkAttr . '>' . $imgTag . '</a>';
                        else :
                            echo '<a href="' . $link . '" ' . $linkAttr . '>' . $imgTag . '</a>';
                        endif;
                    else :
                        echo $imgTag;
                    endif;

                elseif (BannerHelper::isFlash($imageurl)) :
                    // 🔸 Muy antiguo, pero lo dejamos por compatibilidad
                    echo '<object data="' . htmlspecialchars($imageurl, ENT_QUOTES, 'UTF-8') . '" width="' . $width . '" height="' . $height . '"></object>';
                endif;
            endif;
            ?>
    </div>
    <?php endforeach; ?>
</div>

<script>
jQuery(function($) {
    // Efecto hover para cambiar a versión "-color"
    $(".banneritem img").hover(
        function() {
            const src = $(this).attr("src");
            const parts = src.split(".");
            const ext = parts.pop();
            const base = parts.join(".");
            $(this).attr("src", base + "-color." + ext);
        },
        function() {
            $(this).attr("src", $(this).attr("src").replace("-color", ""));
        }
    );
});
</script>