<?php
defined('_JEXEC') or die;

use Joomla\CMS\Router\Route;
use Joomla\Component\Content\Site\Helper\RouteHelper;
use Joomla\CMS\Access\Access;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

// Obtener la ID de la categoría de la URL
// Nota: En una sobrescritura de categoría, es más seguro usar $this->category->id
$categoryId = Factory::getApplication()->input->getInt('id');

// Verificar si el usuario actual tiene permisos para crear un artículo en esta categoría
$canCreate = Access::check('com_content', 'create', 'category.content.' . $categoryId);
?>

<div class="uk-container uk-padding uk-padding-top-remove">

    <?php if ($canCreate) : ?>
    <div class="uk-text-center uk-padding-small">
        <a href="<?php echo Route::_('index.php?option=com_content&task=article.add&catid=' . $categoryId); ?>"
            class="uk-button uk-button-primary">
            <span uk-icon="icon: plus"></span>
            Crear Nuevo Artículo
        </a>
    </div>
    <?php endif; ?>

</div>