<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_articles
 *
 * @copyright   (C) 2024 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;

if ($params->get('articles_layout') == 1) {
    $gridCols = 'grid-cols-' . $params->get('layout_columns');
}

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

$doc = Factory::getDocument();
$doc->addStyleSheet(Uri::base() . 'modules/mod_articles/tmpl/slider/css/style.css');

?>


<div class="uk-padding-small" uk-slider>

    <div class="uk-position-relative uk-text-center">

        <div class="uk-slider-container uk-light">

            <div class="uk-slider-items uk-child-width-1-1 uk-child-width-1-1@s uk-child-width-1-1@m">
                <?php foreach ($items as $item) : ?>

                <?php  $img= json_decode($item->images); ?>
                <?php  $urls= json_decode($item->urls); ?>

                <div><a href="<?= $urls->urla ?>" target="_blank" tabindex="-1">
                    <img src="<?= $img->image_intro ?>" width="1360" height="200" style="border-radius:25px;" alt="">
                    <div class="uk-position-center uk-panel">
                    </div>
                    </a>
                </div>

                <?php endforeach; ?>
            </div>
        </div>

        <div class="uk-hidden@s uk-light">
            <a class="uk-position-center-left uk-position-small" href uk-slidenav-previous
                uk-slider-item="previous"></a>
            <a class="uk-position-center-right uk-position-small" href uk-slidenav-next uk-slider-item="next"></a>
        </div>

        <!--<div class="uk-visible@s">
            <a class="uk-position-center-left-out uk-position-small" href uk-slidenav-previous
                uk-slider-item="previous"></a>
            <a class="uk-position-center-right-out uk-position-small" href uk-slidenav-next uk-slider-item="next"></a>
        </div>-->

    </div>

    <ul class="uk-slider-nav uk-dotnav uk-flex-center uk-margin"></ul>

</div>