<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

$doc = Factory::getDocument();
$doc->addStyleSheet(Uri::base() . 'modules/mod_accordion/css/style.css');
$iconPath = Uri::base() . 'modules/mod_accordion/icons/';
$colors = ['#856437', '#967749', '#a5895a', '#b79a70', '#4c776d', '#416259']; 
$colorIndex = 0;


if ($module->showtitle) {
    echo '<h2 class="uk-text-center uk-margin-medium-bottom">' . htmlspecialchars($module->title) . '</h2>';
}

if (empty($categories) || empty($categories[0]->children)) {
    echo '<p class="uk-text-center uk-text-muted">No hay contenido disponible.</p>';
    return;
}

?>

<div class="contAcc" >
    <div id="list-men" >
        <ul class="uk-flex uk-flex-wrap uk-flex-center uk-margin-remove uk-text-center">
            <?php foreach ($categories[0]->children as $index => $cat): 
            $params = json_decode($cat->params);
            $image = $params->image ?? Uri::base().'images/placeholder.png';
            $color = $colors[$colorIndex];
            $colorIndex = ($colorIndex + 1) % count($colors);
            $words = explode(' ', $cat->title);
            $firstWord = $words[0] ?? '';
            $restWords = implode(' ', array_slice($words, 1));
        ?>
            <li class="uk-text-center uk-padding-remove menc li<?php echo $color; ?>"
                style="background-color:<?php echo $color; ?>;color:#fff;">
                <a href="#" class="category-parent uk-text-center" data-cat="<?php echo $cat->id; ?>"
                    data-description="<?php echo htmlspecialchars($cat->description, ENT_QUOTES, 'UTF-8'); ?>"
                    style="color:#fff;">
                    <img src="<?php echo htmlspecialchars($image); ?>" width="65" height="60" class="uk-border-circle"
                        alt="" style="opacity: 0.8;">
                    <div class="uk-text-small uk-margin-small-top uk-visible@m ">
                        <strong><?php echo htmlspecialchars($firstWord); ?></strong>
                        <?php echo htmlspecialchars($restWords); ?>
                    </div>
                </a>
            </li>
            <?php endforeach; ?>
        </ul>
    </div>
    <div id="descrip" class="uk-text-center uk-padding-small uk-margin-top uk-padding-remove-bottom"></div>

    <!-- Panel principal: izquierda subcategorías, derecha artículos -->
    <div class="uk-grid-small uk-margin-large-top uk-margin-remove uk-padding  uk-padding-remove-top" uk-grid>
        <!-- Accordion izquierda: subcategorías -->
        <div class="uk-width-1-3@m">
            <div id="subcategories-panel"  ><!--uk-sticky="start: 30%;  offset: 80"-->
                <p class="uk-text-muted uk-text-center">
                    <!--Selecciona una categoría padre.-->
                </p>
            </div>
        </div>

        <!-- Contenido derecha: artículos -->
        <div class="uk-width-expand acp" style="background-color:#eae9e5;    padding-left: 0px;
    margin-left: 15px;height: 500px;">
            <div id="articles-panel" class="" style="background-color:#eae9e5">
                <p class="uk-text-muted uk-text-center">
                    <!---Los artículos aparecerán aquí.-->
                </p>
            </div>
        </div>
    </div>

</div>
<script>
/**/
function getPdfFromImageIntro(imagesJson) {
    let images = imagesJson;

    // Si viene como string JSON → parsearlo
    if (typeof imagesJson === 'string') {
        try { 
            images = JSON.parse(imagesJson); 
        } catch(e) { 
            images = {}; 
        }
    }

    if (!images || !images.image_intro) return '';

    let intro = images.image_intro;

    // Quitar lo que esté después del #
    if (intro.includes('#')) {
        intro = intro.split('#')[0];
    }

    // Normalizar
    intro = intro.replace(/^\/+/, '');

    return intro;
}


/**/
document.addEventListener('DOMContentLoaded', () => {
    const data = <?php echo json_encode($categories[0]->children); ?>;
    const descriptionBox = document.getElementById('descrip');

    /* Función para renderizar subcategorías recursivamente */
    function renderCategory(cat, level = 1) {
        const hasChildren = cat.children && cat.children.length > 0;
        const levelClass = `level-${level}`;
        let html = '';

        if (hasChildren) {
            html += `
            <div class="uk-accordion category-block ${levelClass}" uk-accordion="multiple: true">
                <div class="uk-accordion-item">
                    <a class="uk-accordion-title category-link" href="#" data-cat-id="${cat.id}">
                        <span>${cat.title}</span>
                    </a>
                    <div class="uk-accordion-content subcategory-block">
                        ${cat.children.map(sub => renderCategory(sub, level + 1)).join('')}
                    </div>
                </div>
            </div>
            `;
        } else {
            html += `
            <div class="uk-padding-small category-block ${levelClass}">
                <a href="#" class="category-link" data-cat-id="${cat.id}">
                    ${cat.title}
                </a>
            </div>
            `;
        }

        return html;
    }
    /**/
    function normalizeHref(href) {
    if (!href || typeof href !== 'string') return null;

    href = href.trim();

    // Si viene con barras escapadas (por si el JSON vino con backslashes)
    href = href.replace(/\\+/g, '/');

    // Si es protocol-relative //example.com -> añade protocolo del documento
    if (href.startsWith('//')) {
        return window.location.protocol + href;
    }

    // Si ya es absoluta (http o https) la devolvemos tal cual
    if (/^https?:\/\//i.test(href)) {
        return href;
    }

    // Si empieza con una sola barra, es absoluta dentro del dominio actual
    if (href.startsWith('/lgcgmunicipal/')) {
        return window.location.origin + href;
    }

    // Si no tiene protocolo ni slash inicial, asumimos ruta relativa al host actual
    return window.location.origin + '/lgcgmunicipal/' + href;
}
    /**/

    /* Función para encontrar categoría por ID recursivamente */
    function findCategoryById(categories, id) {
        for (let cat of categories) {
            if (cat.id == id) return cat;
            if (cat.children) {
                const result = findCategoryById(cat.children, id);
                if (result) return result;
            }
        }
        return null;
    }

    /* Click en categoría padre: carga subcategorías a la izquierda */
    document.querySelectorAll('.category-parent').forEach(el => {
        el.addEventListener('click', e => {
            e.preventDefault();

            document.querySelectorAll('.menc').forEach(li => li.classList.remove('active-cat'));
            el.closest('.menc').classList.add('active-cat');

            const catId = el.dataset.cat.trim();
            const cat = findCategoryById(data, catId);
            if (!cat) return;

            // Mostrar descripción
            const description = el.dataset.description;
            if (descriptionBox) {
                descriptionBox.innerHTML = description && description.trim() !== "" ?
                    description :
                    "<p class='uk-text-muted'>Sin descripción disponible.</p>";
                descriptionBox.classList.add("uk-animation-fade");
                setTimeout(() => descriptionBox.classList.remove("uk-animation-fade"), 400);
            }

            // Render subcategorías
            const subPanel = document.getElementById('subcategories-panel');
            if (cat.children && cat.children.length > 0) {
                let html = '<ul class="uk-list">';
                cat.children.forEach(sub => {
                    html += renderCategory(sub);
                });
                html += '</ul>';
                subPanel.innerHTML = html;

                // 🔹 Aplicar estado activo al hacer clic en subcategoría
                subPanel.querySelectorAll('.category-link').forEach(link => {
                    link.addEventListener('click', e => {
                        e.preventDefault();

                        // Remover clase active de todos los bloques
                        subPanel.querySelectorAll('.category-block.active')
                            .forEach(block => {
                                block.classList.remove('active');
                            });

                        // Agregar clase active al bloque clickeado
                        const block = link.closest('.category-block');
                        if (block) block.classList.add('active');
                    });
                });
            } else {
                subPanel.innerHTML =
                    '<p class="uk-text-muted uk-text-center">No hay subcategorías.</p>';
            }

            // Reset panel de artículos
            document.getElementById('articles-panel').innerHTML =
                '<p class="uk-text-muted uk-text-center"><!--Selecciona un artículo.--></p>';
        });
    });

    /* Click en subcategoría: mostrar artículos */
    document.getElementById('subcategories-panel').addEventListener('click', e => {
        const link = e.target.closest('a');
        if (!link) return;
        e.preventDefault();

        const catId = link.dataset.catId;
        const category = findCategoryById(data, catId);
       
        if (!category || !category.groups) return;

        // Agrupar artículos por concepto y por año/trimestre
        let articlesByConcept = {};
        for (const concepto in category.groups) {
            const years = category.groups[concepto];
            articlesByConcept[concepto] = {};
            for (const year in years) {
                articlesByConcept[concepto][year] = {
                    'Primer Trimestre': [],
                    'Segundo Trimestre': [],
                    'Tercer Trimestre': [],
                    'Cuarto Trimestre': []
                };
                const quarters = years[year];
                for (const quarter in quarters) {
                    if (Array.isArray(quarters[quarter])) {
                        quarters[quarter].forEach(article => {
                            if (article.field_quarter_value === quarter) {
                                if (!Array.isArray(articlesByConcept[concepto][year][
                                        quarter
                                    ])) {
                                    articlesByConcept[concepto][year][quarter] = [];
                                }
                                articlesByConcept[concepto][year][quarter].push(article);
                            }
                        });
                    }
                }
            }
        }

        // Crear select de años
        const allYears = <?php echo json_encode($categories[0]->allYears ?? []); ?>;
        const yearsAvailable = new Set(allYears.length ? allYears : []);
        for (const concepto in articlesByConcept) {
            for (const year in articlesByConcept[concepto]) {
                yearsAvailable.add(year);
            }
        }
        const sortedYears = Array.from(yearsAvailable).sort((a, b) => b - a);
        const latestYear = sortedYears[0]; // Año más reciente

        let yearFilterHTML = `
    <div class="ef uk-flex uk-flex-between uk-flex-middle uk-margin-small-bottom" style="background-color:#d7be96">
        <span class="  uk-margin-remove uk-padding-small uk-text-right" style="color:#fff;font-size:18pt">Ejercicio <b>Fiscal</b></span>
        <select id="year-filter" class="uk-select" >
`;

        sortedYears.forEach(year => {
            yearFilterHTML += `
        <option value="${year}" ${year == latestYear ? 'selected' : ''}>${year}</option>
    `;
        });

        yearFilterHTML += `
        </select>
    </div>
`;

        const articlesPanel = document.getElementById('articles-panel');
        articlesPanel.innerHTML =
            `<div class="">${yearFilterHTML}<div id="articles-list" class="uk-padding-small"></div></div>`;
            /* 🔹 OCULTAR EF SI ES CAT 262 (aquí sí funciona porque .ef ya existe) */
const efBox = document.querySelector('.ef');
if (catId == "262") {
    if (efBox) efBox.style.display = "none";
} else {
    if (efBox) efBox.style.display = "";
}

        const yearFilter = document.getElementById('year-filter');

        function filterArticlesByYear(year) {
            let filteredArticlesByConcept = {};
            for (const concepto in articlesByConcept) {
                if (articlesByConcept[concepto][year]) {
                    filteredArticlesByConcept[concepto] = {};
                    filteredArticlesByConcept[concepto][year] = articlesByConcept[concepto][year];
                }
            }
            updateTable(filteredArticlesByConcept);
        }

        yearFilter.addEventListener('change', function() {
            filterArticlesByYear(this.value);
        });

        // Mostrar artículos del año más reciente al cargar
        filterArticlesByYear(latestYear);

        /* Función para actualizar la tabla de artículos */
        function updateTable(filteredArticlesByConcept) {
            let updatedHTML = '';
            const articlesList = document.getElementById('articles-list');
            const allArticles = [];

            for (const concepto in filteredArticlesByConcept) {
                for (const year in filteredArticlesByConcept[concepto]) {
                    for (const quarter in filteredArticlesByConcept[concepto][year]) {
                        if (Array.isArray(filteredArticlesByConcept[concepto][year][quarter])) {
                            allArticles.push(...filteredArticlesByConcept[concepto][year][quarter]);
                        }
                    }
                }
            }

            const hasUncategorised = allArticles.some(article => article.field_quarter_value ===
                'Uncategorised');

            if (hasUncategorised) {
                updatedHTML += `
                <table class="uk-table uk-table-divider uk-table-striped uk-table-small" >
                    <thead>
                        <tr><th class="concep">Concepto</th>
                            <th class="doc">Documento</th></tr>
                    </thead>
                    <tbody id="tabla-datos2">
                `;
                for (const concepto in filteredArticlesByConcept) {
                    const uncategorisedArticles = [];
                    for (const year in filteredArticlesByConcept[concepto]) {
                        if (filteredArticlesByConcept[concepto][year]['Uncategorised']) {
                            uncategorisedArticles.push(...filteredArticlesByConcept[concepto][year][
                                'Uncategorised'
                            ]);
                        }
                    }
                    if (uncategorisedArticles.length > 0) {
                        let conceptHtml = '';
                        uncategorisedArticles.forEach(article => {
                            let rawHref2 = getPdfFromImageIntro(article.images);  // ← ahora viene de images.image_intro
                           // const urls = article.urls ? JSON.parse(article.urls) : {};
                            //console.log(urls);
                            //const href = urls.urla || urls.urlb;
                             const href = normalizeHref(rawHref2);
                            if (href) {
                                const safeHref2 = encodeURI(href);
                                console.log(safeHref2);
                                conceptHtml +=
                                    `<li><a class="pdf-link" data-href="${safeHref2}" target="_blank"><img src="modules/mod_accordion/icons/pdf.png" width="50px" /> </a></li>`;
                            }
                        });
                        updatedHTML +=
                            `<tr><td class="tdconce">${concepto}</td>
                            <td class="tdicons"><ul class="uk-list">${conceptHtml}</ul></td></tr>`;
                    }
                }
                updatedHTML += '</tbody></table>';
            } else {
                updatedHTML += `
                <div class="tabla-ejercicio-fiscal uk-padding-small">
               <div class="uk-text-center" uk-grid>
    <div class="uk-width-1-2">
        <div class=""></div>
    </div>
   
    <div class="uk-width-1-2 uk-padding-remove">
        <div class="lettri"><h2 class="uk-margin-remove" style="color:#4c776d">Trimestre</h2></div>
    </div>
</div>

                <table class="uk-table uk-table-divider uk-table-striped uk-table-small  uk-margin-remove-top">
                    <thead>
                    <tr>
        <th class="concep">Concepto</th>
        <th class="trimes">1er</th>
        <th class="trimes">2do</th>
        <th class="trimes">3er</th>
        <th class="trimes">4to</th>
      </tr>
                    </thead>
                    <tbody id="tabla-datos">
                `;
                for (const concepto in filteredArticlesByConcept) {
                    updatedHTML +=
                        `<tr><td class="tdconce">${concepto}</td>`;
                    ['Primer Trimestre', 'Segundo Trimestre', 'Tercer Trimestre', 'Cuarto Trimestre']
                    .forEach(quarter => {
                        let quarterHtml = '';
                        const articles = [];
                        for (const year in filteredArticlesByConcept[concepto]) {
                            articles.push(...(filteredArticlesByConcept[concepto][year][
                                quarter
                            ] || []));
                        }
                       /* articles.forEach(article => {
                            const urls = article.urls ? JSON.parse(article.urls) : {};
                            //const href = urls.urla || urls.urlb;
                           // let rawHref = urls.urla || urls.urlb || urls.urlc || '';
                           let rawHref = getPdfFromImageIntro(article.images);
                            const href = normalizeHref(rawHref);
                            console.log(article);

                            //console.log('DEBUG href raw ->', rawHref, ' normalized ->', href);
                            if (href) {
                                 const safeHref = encodeURI(href);
                                quarterHtml +=
                                    `<li><a class="pdf-link" data-href="${safeHref}" target="_blank"><img src="modules/mod_accordion/icons/pdf.png" width="20%" /></a></li>`;
                            }
                        });*/
                        /**/
                        articles.forEach(article => {
    let rawHref = getPdfFromImageIntro(article.images);  // ← ahora viene de images.image_intro
    const href = normalizeHref(rawHref);

    if (href) {
        const safeHref = encodeURI(href);
        console.log(safeHref);
        quarterHtml += `
            <li>
                <a class="pdf-link" data-href="${safeHref}" target="_blank" rel="noopener noreferrer">
                    <img src="modules/mod_accordion/icons/pdf.png" width="20%" />
                </a>
            </li>`;
    }
});

                        /**/
                        updatedHTML += quarterHtml ?
                            `<td class="tdicons"><ul class="uk-list">${quarterHtml}</ul></td>` :
                            `<td class="tdicons" width="60px"><span class="uk-text-muted"><!--No disponible--></span></td>`;
                    });
                    updatedHTML += '</tr>';
                }
                updatedHTML += '</tbody></table>';
            
            }

            articlesList.innerHTML = updatedHTML;
            /**/
                document.querySelectorAll('#articles-list a.pdf-link').forEach(a => {
    const real = a.dataset.href;
    a.setAttribute('href', real);
});
            /**/
        }
    });
    /**clikkeaable menu izq*/
    /* 🔹 Hace que todo el bloque sea clickeable (solo los que NO son accordion) */
document.getElementById('subcategories-panel').addEventListener('click', function(e) {
    const block = e.target.closest('.category-block');
    if (!block) return;

    // Si el block contiene un accordion, NO hacer nada
    //if (block.querySelector('.uk-accordion')) return;
    if (e.target.closest('.uk-accordion-title')) {
        return; // UIkit lo abrirá normalmente
    }


    // Buscar el link interno
    const link = block.querySelector('.category-link');
    if (link) {
        link.click(); // dispara el clic natural
    }
});
});

document.addEventListener('DOMContentLoaded', function () {

    const subPanel = document.getElementById('subcategories-panel');
    const articlesPanel = document.getElementById('articles-panel');

    const observer = new MutationObserver(() => {

        // Buscar SOLO bloques nivel 1 que sean accordion y estén activos
        const accordionLevel1Active = subPanel.querySelector(
            '.category-block.level-1.uk-accordion.active'
        );

        if (accordionLevel1Active) {
            // Ocultar panel derecho SOLO si es accordion activo
            articlesPanel.style.display = 'none';
        } else {
            // Mostrar panel derecho normalmente
            articlesPanel.style.display = '';
        }

    });

    observer.observe(subPanel, {
        attributes: true,
        subtree: true,
        attributeFilter: ['class']
    });




    /**/
    // 🔹 Activar automáticamente la primera categoría padre
const firstCat = document.querySelector('.category-parent');
if (firstCat) {
    setTimeout(() => {
        firstCat.click();

        // 🔹 Esperar a que las subcategorías se hayan renderizado
        setTimeout(() => {
            const firstSub = document.querySelector('#subcategories-panel .category-link');
            if (firstSub) {
                firstSub.click();
            }
        }, 400);

    }, 200);
}


});

document.querySelectorAll('#articles-list a.pdf-link').forEach(a => {
    const real = a.dataset.href;
    a.setAttribute('href', real);
});
document.addEventListener('DOMContentLoaded', () => {

    // ... (tu código original)

    // 🔹 Activar automáticamente la primera categoría del menú superior
    const firstCat = document.querySelector('.category-parent');
    if (firstCat) {
        setTimeout(() => firstCat.click(), 200);
    }

});


</script>