
<?php $__env->startSection('title', 'Inicio'); ?>
<?php $__env->startSection('meta-description',
    'Bienvenido a la página de inicio del Comité de Igualdad Laboral y No Discriminación de la
    Secretaría de Planeación, Finanzas y Administración del Gobierno del Estado de Puebla.'); ?>
<?php $__env->startSection('canonical-url', url()->current()); ?>
<?php $__env->startSection('keywords',
    'Inicio, Comité Igualdad Laboral, No Discriminación, Secretaría de Planeación, Finanzas y Administración, Gobierno
    del Estado de Puebla, Igualdad de Género, No Discriminación Laboral, Puebla, Progreso, Transparencia, Información'); ?>
<?php $__env->startSection('og-title', 'Inicio - Comité de Igualdad Laboral y No Discriminación'); ?>
<?php $__env->startSection('og-description',
    'Bienvenido a la página de inicio del Comité de Igualdad Laboral y No Discriminación de la
    Secretaría de Planeación, Finanzas y Administración del Gobierno del Estado de Puebla.'); ?>
<?php $__env->startSection('og:url', url()->current()); ?>
<?php $__env->startSection('twitter-title', 'Inicio - Comité de Igualdad Laboral y No Discriminación'); ?>
<?php $__env->startSection('twitter-description',
    'Bienvenido a la página de inicio del Comité de Igualdad Laboral y No Discriminación de
    la Secretaría de Planeación, Finanzas y Administración del Gobierno del Estado de Puebla.'); ?>
<?php $__env->startSection('css'); ?>
    <?php echo NoCaptcha::renderJs(); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('jss'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php if($message = Session::get('success')): ?>
        <script>
            Swal.fire({
                icon: 'success',
                title: '<?php echo e($message); ?>'
            })
        </script>
    <?php endif; ?>
    <section class="seccion-inicial">
        <div class="container">
            <div class="row">
                <div class="col-12 col-md-6 titulo">
                    <h1 class="titulo-h1">
                        Comité de Igualdad Laboral y No
                        Discriminación
                    </h1>
                    <p class="text-justify">
                        Promover e incorporar la igualdad laboral y no
                        discriminación como valor institucional al interior de la
                        Secretaría de Planeación, Finanzas y Administración
                    </p>
                    <a href="contacto" class="btn btn-orange" title="Contáctanos" rel="noopener" target="_self">
                        Contáctanos</a>
                </div>
                <div class="col-12 col-md-6 imagen">
                    <div id="carouselExampleControls" class="carousel slide" data-ride="carousel">
                        <div class="carousel-inner">
                            <div class="carousel-item active">
                                <div class="img-box">
                                    <img src="<?php echo e(asset('imagenes/carrusel-inicio/1.jpg')); ?>" alt="imagen de carrusel 1"
                                        title="imagen de carrusel 1">
                                </div>
                            </div>
                            <div class="carousel-item">
                                <div class="img-box">
                                    <img src="<?php echo e(asset('imagenes/carrusel-inicio/2.jpg')); ?>" alt="imagen de carrusel 2"
                                        title="imagen de carrusel 2">
                                </div>
                            </div>
                            <div class="carousel-item">
                                <div class="img-box">
                                    <img src="<?php echo e(asset('imagenes/carrusel-inicio/3.jpg')); ?>" alt="imagen de carrusel 3"
                                        title="imagen de carrusel 3">
                                </div>
                            </div>
                            <div class="carousel-item">
                                <div class="img-box">
                                    <img src="<?php echo e(asset('imagenes/carrusel-inicio/4.jpg')); ?>" alt="imagen de carrusel 4"
                                        title="imagen de carrusel 4">
                                </div>
                            </div>
                            <div class="carousel-item">
                                <div class="img-box">
                                    <img src="<?php echo e(asset('imagenes/carrusel-inicio/5.jpg')); ?>" alt="imagen de carrusel 5"
                                        title="imagen de carrusel 5">
                                </div>
                            </div>
                        </div>
                    </div>
                    <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleControls"
                        data-bs-slide="prev">
                        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">Anterior</span>
                    </button>
                    <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleControls"
                        data-bs-slide="next">
                        <span class="carousel-control-next-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">Siguiente</span>
                    </button>
                </div>
            </div>
        </div>

    </section>
    
    <section id="about_section" class="about_section layout_padding">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <div class="detail-box">
                        <div class="heading_container">
                            <h2 class="titulo-h2">Sobre nosotros</h2>
                        </div>
                        <p class="text-justify">
                            Somos un equipo de trabajo conformado por personas de diversas
                            unidades administrativas de la Secretaría de Planeación, Finanzas y Administración, cuyo fin es
                            promover e incorporar la Igualdad
                            Laboral y No Discriminación como valor institucional al
                            interior de la Secretaría, nuestro objetivo es alcanzar un
                            equilibrio integral en el ejercicio de los derechos del
                            personal que forma parte de esta Dependencia, a través de la
                            igualdad de oportunidades.
                        </p>
                        <a href="<?php echo e(url('/acercade')); ?>" title="Acerca del Comité" rel="noopener" target="_self">
                            Leer
                            más
                        </a>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="img_container">
                        <div class="img-box b1">
                            <img src="<?php echo e(asset('imagenes/carrusel-inicio/8.jpg')); ?>" alt="Imagen de Acerca de Nosotros"
                                title="Imagen de Acerca de Nosotros">
                        </div>
                        <div class="img-box b2">
                            <img src="<?php echo e(asset('imagenes/carrusel-inicio/7.jpg')); ?>" alt="Imagen 2 de Acerca de Nosotros"
                                title="Imagen 2 de Acerca de Nosotros">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <section id="infografias" class="secccion_infografias">
        <div class="container">
            <div class="heading_container text-center">
                <h2 class="titulo-h2">Infografías</h2>
            </div>
            <div class="container-fluid">
                <div class="row justify-content-center">
                    <div class="col-md-12">
                        <div id="infographicsCarousel" class="carousel slide" data-ride="carousel">
                            <div class="carousel-indicators">
                                <?php $__currentLoopData = $infografias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $infografia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <button type="button" data-bs-target="#infographicsCarousel"
                                        data-bs-slide-to="<?php echo e($index); ?>" class="<?php echo e($index == 0 ? 'active' : ''); ?>"
                                        aria-label="Slide <?php echo e($index + 1); ?>"
                                        <?php echo e($index == 0 ? 'aria-current="true"' : ''); ?>></button>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <div class="carousel-inner">
                                <?php $__currentLoopData = $infografias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $infografia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="carousel-item <?php echo e($index == 0 ? 'active' : ''); ?>">
                                        <div class="box text-center">
                                            <div class="img-box">
                                                <img src="<?php echo e(asset('imagenes/infografias-carpeta/' . $infografia->infografia)); ?>"
                                                    alt="<?php echo e($infografia->nombre); ?>" class="img-fluid"
                                                    title="<?php echo e($infografia->nombre); ?>">
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <button class="carousel-control-prev" type="button" data-bs-target="#infographicsCarousel"
                                data-bs-slide="prev">
                                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                <span class="visually-hidden">Anterior</span>
                            </button>
                            <button class="carousel-control-next" type="button" data-bs-target="#infographicsCarousel"
                                data-bs-slide="next">
                                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                <span class="visually-hidden">Siguiente</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="text-center">
                <a href="galeria-infografias" class="btn btn-orange mt-3" title="Galería de Infografías" rel="noopener"
                    target="_self">Ver más</a>
            </div>
        </div>
    </section>

    <section id="blogs" class="about_section layout_padding">
        <div class="container">
            <div class="heading_container text-center">
                <h2 class="titulo-h2">Blogs</h2>
            </div>
            <div class="row">
                <?php if($blogs->count() > 0): ?>
                    <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12 col-12">
                            <div class="blog-card">
                                <div class="blog-card-img">
                                    <a href="<?php echo e(route('blogs.mostrar', $blog->slug)); ?>" title="<?php echo e($blog->titulo); ?>"
                                        rel="noopener" target="_self">
                                        <img src="<?php echo e(asset($blog->imagen_1)); ?>"
                                            alt="Imagen del blog <?php echo e($blog->titulo); ?>"
                                            title="Imagen del blog <?php echo e($blog->titulo); ?>">
                                    </a>
                                </div>
                                <div class="blog-card-text-area">
                                    <div class="blog-date">
                                        <ul>
                                            <li>
                                                <i class="fas fa-user"></i>
                                                Por
                                                <a href="<?php echo e(url('/integrantes')); ?>" target="_self" rel="noopener"
                                                    title="Integrantes">
                                                    Admin
                                                </a>
                                            </li>
                                            <li>
                                                <i class="far fa-calendar-alt"></i>
                                                <?php echo e(\Carbon\Carbon::parse($blog->published_at)->locale('es')->isoFormat('DD MMM YYYY')); ?>

                                            </li>
                                        </ul>
                                    </div>
                                    <h4 class="titulo-blog-tarjeta">
                                        <a href="<?php echo e(route('blogs.mostrar', $blog->slug)); ?>" title="<?php echo e($blog->titulo); ?>"
                                            rel="noopener" target="_self">
                                            <?php echo e($blog->titulo); ?>

                                        </a>
                                    </h4>
                                    <p class="extracto-tarjeta">
                                        <?php echo e($blog->extracto); ?>

                                    </p>
                                </div>
                                <div class="container d-flex justify-content-center">
                                    <a class="read-more-btn" href="<?php echo e(route('blogs.mostrar', $blog->slug)); ?>"
                                        title="<?php echo e($blog->titulo); ?>" rel="noopener" target="_self">
                                        Leer Más
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <h4 class="text-center">No hay blogs disponibles.</h4>
                <?php endif; ?>

                <div class="text-center">
                    <a href="eventos#blogs" class="btn btn-orange mt-3" title="Galería de Infografías" rel="noopener"
                        target="_self">Ver más</a>
                </div>
            </div>
        </div>
    </section>
    <section class="contact_section layout_padding">
        <div class="container">
            <div class="heading_container">
                <h2 class="titulo-h2">Contáctanos</h2>
            </div>
        </div>
        <div class="container">
            <div class="row">
                <div style="margin-top:20px">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success text-center">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>
                </div>
                <div class="col-md-6">
                    <div class="">
                        <form action="<?php echo e(route('panel-quejas.store')); ?>" method="post" enctype="multipart/form-data"
                            novalidate>
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <label for="nombre">Nombre completo:</label>
                                <input type="text" id="nombre" name="nombre" class="form-control" required>
                                <?php $__errorArgs = ['nombre'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group">
                                <label for="correo">Correo electrónico:</label>
                                <input type="email" id="correo" name="correo" class="form-control" required>
                                <?php $__errorArgs = ['correo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group">
                                <label for="telefono">Número de teléfono:</label>
                                <input type="tel" id="telefono" name="telefono" class="form-control" required>
                                <?php $__errorArgs = ['telefono'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group">
                                <label for="tipo_discriminacion">Tipo de Queja:</label>
                                <select id="tipo_discriminacion" name="tipo_discriminacion" class="form-control"
                                    required>
                                    <option value="" disabled selected>Seleccione</option>
                                    <option value="Acoso y Hostigamiento Sexual">Acoso y Hostigamiento Sexual</option>
                                    <option value="Acoso y Hostigamiento Laboral">Acoso y Hostigamiento Laboral
                                    </option>
                                    <option value="Discriminación">Discriminación</option>
                                </select>
                                <?php $__errorArgs = ['tipo_discriminacion'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group">
                                <label for="queja">Describa su queja:</label>
                                <textarea id="queja" name="queja" class="form-control" rows="4" required></textarea>
                                <?php $__errorArgs = ['queja'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div id="descarga-formato" class="form-group" style="display:none;">
                                <p>Descarga el siguiente formato, llénalo y adjúntalo al siguiente apartado.</p>
                                <a id="descargar-formato" class="btn btn-orange" href="#" download
                                    title="Formato de Queja" rel="noopener">Descargar
                                    formato</a>
                            </div>

                            <div class="form-group">
                                <label for="formato">Adjuntar documento (solo PDF o Word):</label>
                                <input type="file" id="formato" name="formato" class="form-control"
                                    accept=".pdf,.docx" required>
                                <?php $__errorArgs = ['formato'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12">
                                <?php echo NoCaptcha::display(); ?>

                                <?php $__errorArgs = ['g-recaptcha-response'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group">
                                <label>Documentos complementarios</label>
                            </div>
                            <div class="form-group">
                                <p>Descarga el siguiente directorio, para que encuentres la instancia más cercana a ti y
                                    puedas continuar con el procedimiento de tu incidente.</p>
                                <a class="btn btn-orange" href="<?php echo e(asset('documentos/Directorio-Protocolo.pdf')); ?>"
                                    download title="Directorio" rel="noopener">Descargar directorio</a>
                            </div>

                            <!-- Modal de Bootstrap -->
                            <div class="modal fade" id="avisoPrivacidadModal" tabindex="-1"
                                aria-labelledby="avisoPrivacidadModalLabel" aria-hidden="true">
                                <div class="modal-dialog modal-xl">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="avisoPrivacidadModalLabel">Aviso de Privacidad
                                            </h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Cerrar"></button>
                                        </div>
                                        <div class="modal-body">
                                            <iframe class="w-100" id="avisoPrivacidadIframe" src=""></iframe>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Modificación en el Formulario -->
                            <div class="form-group">
                                <label>Aviso de privacidad</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <button type="button" class="btn btn-orange-2 btn-aviso-privacidad mt-0 w-100"
                                            data-tipo="simplificado">Simplificado</button>
                                    </div>
                                    <div class="col-md-6">
                                        <button type="button" class="btn btn-orange-2 btn-aviso-privacidad mt-0 w-100"
                                            data-tipo="integral">Integral</button>
                                    </div>
                                </div>
                            </div>

                            <!-- Botones de documentos extras -->
                            <div class="form-group">
                                <label>Anexos</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <a class="btn btn-orange-2 w-100"
                                            href="<?php echo e(asset('documentos/6._Anexo_IX.4._Minuta_de_Resolución.docx')); ?>"
                                            download rel="noopener" title="Minuta de Resolución">Minuta de
                                            Resolución</a>
                                    </div>
                                    <div class="col-md-6">
                                        <a class="btn btn-orange-2 w-100"
                                            href="<?php echo e(asset('documentos/5._Anexo_IX.3._Minuta_de_Entrevista_Protocolo_y_Acuerdo.docx')); ?>"
                                            download title="Minuta de Entrevista Protocolo y Acuerdo"
                                            rel="noopener">Minuta de Entrevista Protocolo y Acuerdo</a>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <input type="submit" value="Enviar" class="btn btn-orange">
                            </div>
                        </form>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="map_container">
                        <div class="map-responsive">
                            <iframe id="iframe-mapa-contacto"
                                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d629.3230731027531!2d-98.18690585600862!3d19.03395814966306!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x85cfc7113bf027f9%3A0x5019db208e053e0!2sSecretaria%20de%20Finanzas%20de%20Gobierno%20del%20Puebla!5e0!3m2!1sen!2smx!4v1695752002387!5m2!1sen!2smx"
                                width="600" height="640" allowfullscreen title="Ifram de Google Maps"
                                loading="lazy"></iframe>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script>
        document.getElementById('tipo_discriminacion').addEventListener('change', function() {
            var descargaFormatoDiv = document.getElementById('descarga-formato');
            var descargarFormatoLink = document.getElementById('descargar-formato');

            if (this.value === 'Acoso y Hostigamiento Sexual') {
                descargaFormatoDiv.style.display = 'block';
                descargarFormatoLink.href =
                    '<?php echo e(asset('documentos/Formato de Queja Acoso, Hostigamiento Sexual.docx')); ?>';
            } else if (this.value === 'Acoso y Hostigamiento Laboral') {
                descargaFormatoDiv.style.display = 'block';
                descargarFormatoLink.href =
                    '<?php echo e(asset('documentos/Formato de Queja Acoso, Hostigamiento Laboral y Discriminación.docx')); ?>';
            } else if (this.value === 'Discriminación') {
                descargaFormatoDiv.style.display = 'block';
                descargarFormatoLink.href =
                    '<?php echo e(asset('documentos/Formato de Queja Acoso, Hostigamiento Laboral y Discriminación.docx')); ?>';
            } else {
                descargaFormatoDiv.style.display = 'none';
            }
        });

        document.querySelectorAll('.btn-aviso-privacidad').forEach(button => {
            button.addEventListener('click', function() {
                var tipo = this.getAttribute('data-tipo');
                var iframe = document.getElementById('avisoPrivacidadIframe');
                if (tipo === 'simplificado') {
                    iframe.src = '<?php echo e(asset('documentos/AvisoPrivacidadSimplificado.pdf')); ?>';
                } else if (tipo === 'integral') {
                    iframe.src = '<?php echo e(asset('documentos/AvisoPrivacidadIntegral.pdf')); ?>';
                }
                var modal = new bootstrap.Modal(document.getElementById('avisoPrivacidadModal'));
                modal.show();
            });
        });
    </script>
    <!-- <script>
        document.addEventListener("DOMContentLoaded", function() {
            var bannerModal = new bootstrap.Modal(document.getElementById('bannerModal'));
            bannerModal.show();
        });
    </script> -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('componentes.plantilla', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/resources/views/inicio.blade.php ENDPATH**/ ?>