
<?php $__env->startSection('title', 'Integrantes'); ?>
<?php $__env->startSection('meta-description',
    'Conoce a los integrantes del Comité de Igualdad Laboral y No Discriminación de la
    Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla, quienes lideran y promueven nuestros valores de
    igualdad y no discriminación en la institución.'); ?>
<?php $__env->startSection('canonical-url', url()->current()); ?>
<?php $__env->startSection('keywords',
    'Integrantes, Comité Igualdad Laboral, No Discriminación, Secretaría de Planeación y Finanzas,
    Gobierno del Estado de Puebla, Igualdad de Género, No Discriminación Laboral, Desarrollo Sostenible, Agenda 2030, ODS,
    Puebla, Organigrama, Equipo de Trabajo'); ?>
<?php $__env->startSection('og-title', 'Integrantes - Comité de Igualdad Laboral y No Discriminación'); ?>
<?php $__env->startSection('og-description',
    'Conoce a los integrantes del Comité de Igualdad Laboral y No Discriminación de la Secretaría
    de Planeación y Finanzas del Gobierno del Estado de Puebla, quienes lideran y promueven nuestros valores de igualdad y
    no discriminación en la institución.'); ?>
<?php $__env->startSection('og:url', url()->current()); ?>
<?php $__env->startSection('twitter-title', 'Integrantes - Comité de Igualdad Laboral y No Discriminación'); ?>
<?php $__env->startSection('twitter-description',
    'Conoce a los integrantes del Comité de Igualdad Laboral y No Discriminación de la
    Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla, quienes lideran y promueven nuestros valores de
    igualdad y no discriminación en la institución.'); ?>
<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('jss'); ?>
    <script>
        // Función para mostrar información en la ventana emergente
        function showInfo(title, content, imgAlt, imgSrc, reseña, contacto) {
            var modalTitle = document.getElementById("infoModalLabel");
            var modalBody = document.getElementById("modalBody");

            // Actualizar el contenido del modal
            modalTitle.innerHTML = title;
            var contentHTML = "<div class='text-center mb-4'>";

            // Imagen centrada
            if (imgAlt && imgSrc) {
                contentHTML += '<img src="' + imgSrc + '" alt="' + imgAlt +
                    '" class="img-fluid president-image rounded mb-3" style="max-width: 200px;">';
            }

            // Nombre o posición del integrante
            contentHTML += "<h5 class='texto-comite'>" + content + "</h5>";
            contentHTML += "</div>";

            // Reseña
            if (reseña) {
                contentHTML += "<p class='text-justify'><strong>Reseña:</strong> " + reseña + "</p>";
            }

            // Datos de contacto
            if (contacto) {
                contentHTML += "<p><strong>Datos de Contacto:</strong></p>";
                contentHTML += "<ul class='list-unstyled'>";
                if (contacto.correo) {
                    contentHTML += "<li><i class='fas fa-envelope'></i> " + contacto.correo + "</li>";
                }
                if (contacto.telefono) {
                    contentHTML += "<li><i class='fas fa-phone'></i> " + contacto.telefono + "</li>";
                }
                contentHTML += "</ul>";
            }

            modalBody.innerHTML = contentHTML;

            // Mostrar el modal de Bootstrap
            var infoModal = new bootstrap.Modal(document.getElementById('infoModal'), {
                keyboard: true
            });
            infoModal.show();
        }
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="modal fade" id="infoModal" tabindex="-1" aria-labelledby="infoModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="infoModalLabel"></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="modalBody">
                    <!-- Contenido del modal se cargará dinámicamente -->
                </div>
            </div>
        </div>
    </div>
    <section class="about_section layout_padding"
        style="background-image: url('<?php echo e(asset('imagenes/fondo5.png')); ?>'); background-size: cover; background-repeat: no-repeat;">
        <h1 class="titulo-h1">Integrantes del Comité</h1>
        <div class="container contenedor-flex">
            <div class="row">
                <div class="col text-center">
                    <a href="#"
                        onclick="showInfo('Presidencia', 'Josefina Morales Guerrero', 'images/persona1.jpg', '<?php echo e(asset('imagenes/integrantes/Josefina Morales GuerreroC.jpg')); ?>', 'Tiene maestrías en Administración y Finanzas Públicas y una licenciatura en Ciencias de la Computación. Ha contribuido al posicionamiento destacado de la entidad en mediciones nacionales e internacionales relacionadas con temas gubernamentales. Su responsabilidad principal incluye la elaboración de la Ley de Egresos del Estado, la supervisión de Estados Financieros, y la implementación de iniciativas de Presupuesto basado en Resultados, seguimiento de indicadores y la inclusión de perspectiva de género y niñas, niños y adolescentes en el presupuesto', { correo: 'josefina.morales@puebla.gob.mx', telefono: 'Extensión: 7164' })">
                        <img src="<?php echo e(asset('imagenes/integrantes/presidencia.png')); ?>" alt="Josefina Morales Guerrero"
                            title="Josefina Morales Guerrero" width="300">
                    </a>
                </div>
            </div>
            <div class="row">
                <div class="col text-center">
                    <a href="#"
                        onclick="showInfo('Coordinador', 'Ramón Montes Barreto', 'images/persona1.jpg', '<?php echo e(asset('imagenes/integrantes/Coordinador-Ramon.jpg')); ?>', ' Es Doctorado en Administración Pública con mención honorífica por el Instituto de Administración Pública del Estado Puebla; Tiene un Doctorado en Estudios de Género y Derecho por el Instituto Universitario Puebla. Cuenta con estudios de Doctorado en Administración por la Universidad Nacional Autónoma de México, UNAM; Así como la Maestría en Desarrollo Organizacional por la Universidad de Monterrey. Es Licenciado en Psicología de Trabajo por la UNAM donde obtuvo mención honorífica.', { correo: 'comiteigualdadspf@puebla.gob.mx', telefono: 'Extensión 7142' })">
                        <img src="<?php echo e(asset('imagenes/integrantes/coordinador.png')); ?>" alt="Ramon Montes Barreto"
                            title="Ramon Montes Barreto" width="300">
                    </a>
                </div>
                <div class="col text-center">
                    <a href="#"
                        onclick="showInfo('Ombudsperson', 'Enrique de Jesús Farpón Nava', 'images/persona1.jpg', '<?php echo e(asset('imagenes/integrantes/Ombudspersona-Enrique.jpg')); ?>', 'Originario de la Ciudad de Puebla, México, Enrique de Jesús es licenciado en derecho por la Universidad Los Ángeles UA. Actualmente, está cursando una maestría en Derecho Procesal Civil con especialización en juicios orales en CESCIJUC. Posee amplia experiencia en diversas ramas del derecho, habiendo trabajado como meritorio en el Juzgado Segundo de Distrito y como analista jurídico en la Procuraduría Fiscal de la Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla, en el departamento de Juicios de Nulidad.', { correo: 'enrique.farpon@puebla.gob.mx', telefono: '' })">
                        <img src="<?php echo e(asset('imagenes/integrantes/ombudsperson.png')); ?>" alt="Enrique de Jesús Farpón Nava"
                            title="Enrique de Jesús Farpón Nava" width="300">
                    </a>
                </div>
            </div>
            <div class="row">
                <div class="col text-center">
                    <a href="#"
                        onclick="showInfo('Vocal de la Procuraduría Fiscal', 'Narciso Bernabé Hernández Benítez', 'Foto de Vocal', '<?php echo e(asset('imagenes/integrantes/Vocal-Narciso.jpg')); ?>', 'Licenciado en Derecho por la Benemérita Universidad Autónoma de Puebla. Con una carrera de 19 años en el Servicio de Administración Tributaria, ha desempeñado roles clave, desde notificador hasta Subadministrador Desconcentrado Jurídico. Actualmente, en la Procuraduría Fiscal del Gobierno del Estado de Puebla, se destaca como Analista Especializado Consultivo “A”. Su vida está marcada por una sólida vocación de servicio, tanto en lo personal como en lo profesional.', { correo: 'narciso.hernandez@puebla.gob.mx', telefono: '' })">
                        <img src="<?php echo e(asset('imagenes/integrantes/vocal1.png')); ?>" alt="Narciso Bernabé Hernández Benítez"
                            title="Narciso Bernabé Hernández Benítez" width="200">
                    </a>
                </div>
                <div class="col text-center">
                    <a href="#"
                        onclick="showInfo('Vocal Subsecretaría de Ingresos', 'Martha Alejandra Gil Curiel', 'images/persona1.jpg', '<?php echo e(asset('imagenes/integrantes/Vocal-Martha.jpg')); ?>', 'Cuenta con estudios en Administración de Empresas y una amplia formación y experiencia en áreas como Administración Pública, Calidad en el Servicio, Transparencia, Igualdad y No Discriminación. Ha trabajado en la Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla durante los últimos 5 años y ha sido miembro del Comité de Igualdad Laboral y No Discriminación desde febrero de 2020. Su objetivo principal es apoyar la implementación de prácticas de igualdad laboral para promover el desarrollo integral de los trabajadores de la Secretaría.', { correo: 'martha.gil@puebla.gob.mx', telefono: '222 229 7000  Ext. 3003' })">
                        <img src="<?php echo e(asset('imagenes/integrantes/vocal2.png')); ?>" alt="Martha Alejandra Gil Curiel"
                            width="200">
                    </a>
                </div>
                <!-- <div class="col text-center">
                    <a href="#"
                        onclick="showInfo('Vocal Subsecretaría de Egresos', 'Elizabeth Munive Montiel', 'Foto de Vocal 3', '<?php echo e(asset('imagenes/integrantes/Vocal-Elizabeth.jpg')); ?>', 'Es una licenciada en Administración Pública y Ciencias Políticas, con una Maestría en Fiscalización y Rendición de Cuenta. Tiene experiencia en auditorías y evaluaciones, y ha obtenido una certificación EC0105 en Atención al ciudadano en el sector público. Su compromiso con la igualdad laboral y la no discriminación se refleja en su trabajo para cumplir con la Norma Mexicana NMX R 025 SCFI 2015 en su entorno laboral.', { correo: 'elizabeth.munive@puebla.gob.mx', telefono: '222 229 7000 Ext. 7175' })">
                        <img src="<?php echo e(asset('imagenes/integrantes/vocal3.png')); ?>" alt="Elizabeth Munive Montiel"
                            title="Elizabeth Munive Montiel" width="200">
                    </a>
                </div> -->
                <div class="col text-center">
                    <a href="#"
                        onclick="showInfo('Vocal Subsecretaría de Planeación', 'Daniel Mitzin Montiel', 'images/persona1.jpg', '<?php echo e(asset('imagenes/integrantes/Vocal-Daniel.jpg')); ?>', 'Nacido el 21 de julio de 1965, es Contador Público y Auditor con 34 años de experiencia en el sector público. Ha trabajado en diversas áreas de la Secretaría de Finanzas y Administración, y actualmente se desempeña como Analista de Recursos Humanos en la Subsecretaría de Planeación. Además, participa activamente en el Comité de Igualdad Laboral y No Discriminación, enfocándose en temas de derechos humanos, igualdad laboral, equidad de género y justicia.', { correo: 'daniel.mitzin@puebla.gob.mx', telefono: '221 249 8132 Ext. 5057' })">
                        <img src="<?php echo e(asset('imagenes/integrantes/vocal4.png')); ?>" alt="Daniel Mitzin Montiel"
                            title="Daniel Mitzin Montiel" width="200">
                    </a>
                </div>
            </div>
            <div class="row">
                <div class="col text-center">
                    <a href="#"
                        onclick="showInfo('Vocal de la Unidad de Inteligencia Patrimonial', 'Adolfo Jacobo Velez Montaño', 'Imagen de la persona vocal', '<?php echo e(asset('imagenes/integrantes/Vocal-Adolfo.jpg')); ?>', 'Abogado con más de 15 años de experiencia en áreas legales como civil, mercantil, laboral, amparo y fiscal-administrativo. Actualmente cursa un Doctorado en Ciencias Penales y Juicios Orales. Es miembro fundador del Plan Zafiro de la ODAT de la Embajada de los Estados Unidos en México. Está comprometido con la equidad de género y la igualdad laboral, y como miembro del comité, trabaja para crear entornos laborales seguros e inclusivos..', { correo: 'adolfo.velez@puebla.gob.mx', telefono: '222 229 7000 Ext. 4105' })">
                        <img src="<?php echo e(asset('imagenes/integrantes/vocal5.png')); ?>" alt="Adolfo Jacobo Velez Montaño"
                            title="Adolfo Jacobo Velez Montaño" width="200">
                    </a>
                </div>
                <div class="col text-center">
                    <a href="#"
                        onclick="showInfo('Vocal Dirección General Jurídica', 'Sonia Ocampo Munive', 'Imagen de la persona vocal', '<?php echo e(asset('imagenes/integrantes/Vocal-Sonia.jpg')); ?>', 'La Licenciada en Derecho tiene 32 años de experiencia en la dependencia, actualmente trabajando como Enlace Administrativa de la Dirección General Jurídica. Quiere contribuir al Comité de Igualdad Laboral y No Discriminación para promover la igualdad de género y eliminar la discriminación en la dependencia. Su objetivo es apoyar a otros y generar cambios que garanticen igualdad de derechos y una cultura laboral inclusiva y libre de violencia.', { correo: 'sonia.ocampo@puebla.gob.mx', telefono: '222 229 7000 Ext. 4114' })">
                        <img src="<?php echo e(asset('imagenes/integrantes/vocal6.png')); ?>" alt="Sonia Ocampo Munive"
                            title="Sonia Ocampo Munive" width="200">
                    </a>
                </div>
                <div class="col text-center">
                    <a href="#"
                        onclick="showInfo('Vocal Dirección Administrativa', 'Pedro Lecona Villa', 'Imagen de la persona vocal', '<?php echo e(asset('imagenes/integrantes/Vocal-Pedro.jpg')); ?>', 'Es el Coordinador Consultivo en la Dirección Administrativa de la Secretaría de Planeación y Finanzas desde 2006, con una trayectoria de 56 años en el servicio público. Ha ocupado varios puestos de alta importancia. En cuanto a los temas del comité, está comprometido con las políticas de igualdad laboral y no discriminación, y busca impulsar la perspectiva de género y el respeto a los derechos de los grupos vulnerables. Trabaja para establecer lineamientos que promuevan la inclusión y combatan la discriminación en el lugar de trabajo.', { correo: 'pedro.lecona@puebla.gob.mx', telefono: '222 229 7000 Ext. 7123' })">
                        <img src="<?php echo e(asset('imagenes/integrantes/vocal7.png')); ?>" alt="Pedro Lecona Villa"
                            title="Pedro Lecona Villa" width="200">
                    </a>
                </div>
                <div class="col text-center">
                    <a href="#"
                        onclick="showInfo('Vocal Dirección Administrativa', 'Miguel Angel Morales Hernández', 'Imagen de la persona vocal', '<?php echo e(asset('imagenes/integrantes/Vocal-Miguel.png')); ?>', ' Ha trabajado en roles de liderazgo en el sector público, específicamente en el Instituto Registral y Catastral y en la Secretaría de Planeación y Finanzas. Su interés en los temas del comité se centra en la difusión de las acciones del comité para informar a todo el personal sobre sus funciones. Además, está comprometido con la formulación de propuestas de soluciones a los asuntos presentados, proporcionando un acompañamiento oportuno al personal que presenta alguna queja.', { correo: 'miguel.morales@puebla.gob.mx', telefono: '222 229 7000 Ext. 4110' })">
                        <img src="<?php echo e(asset('imagenes/integrantes/vocal8.png')); ?>" alt="Miguel Angel Morales Hernández"
                            title="Miguel Angel Morales Hernández" width="200">
                    </a>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('componentes.plantilla', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/resources/views/integrantes.blade.php ENDPATH**/ ?>