<?php if (isset($component)) { $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\AppLayout::class, []); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
    <?php $__env->startSection('title', 'Blogs: Inicio'); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('Blogs del Comité')); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="container py-12 mx-auto">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="" style="background-color: white; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);">
                <div class="container ">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('crear-blog')): ?>
                    <a href="<?php echo e(route('panel-blogs.create')); ?>" class="">
                        <button class="btn btn-primary mt-3 mb-3 ml-3">
                            Subir nuevo
                        </button>
                    </a>
                    <?php endif; ?>
                </div>
                <div class="container">
                    <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert"
                            aria-label="Close"></button>
                    </div>
                    <?php endif; ?>
                    <table id="myTable" class="table table-striped" style="width:100%">
                        <thead>
                            <tr>
                                <th>Título</th>
                                
                                <th>Extracto</th>
                                
                                <th>Miniatura</th>
                                
                                <th>Fecha Publicación</th>
                                <th>¿Publicado?</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if($blogs): ?>
                            <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <a href="<?php echo e(route('blogs.mostrar', $blog->slug)); ?>" title="<?php echo e($blog->titulo); ?>"
                                        rel="noopener" target="_blank"><?php echo e($blog->titulo); ?>

                                    </a>
                                </td>
                                <td><?php echo e($blog->extracto); ?></td>
                                <td>
                                    <a href="<?php echo e(asset($blog->imagen_1)); ?>" target="_blank">
                                        <img src="<?php echo e(asset($blog->imagen_1)); ?>" class="img-thumbnail"
                                            width="100%">
                                    </a>
                                </td>
                                <td>
                                    <?php echo e(\Carbon\Carbon::parse($blog->published_at)->locale('es')->translatedFormat('d \d\e F \d\e Y')); ?>

                                </td>
                                <td><?php echo e($blog->is_published ? 'Sí' : 'No'); ?></td>
                                <td>
                                    <div class="flex justify-center rounded-lg text-lg" role="group">
                                        <!-- botón editar -->
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('editar-blog')): ?>
                                        <a href="<?php echo e(route('panel-blogs.edit', $blog->id)); ?>" class="">
                                            <button class="btn btn-secondary">
                                                Editar
                                            </button>
                                        </a>
                                        <?php endif; ?>
                                        <!-- botón borrar -->
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('borrar-blog')): ?>
                                        <form action="<?php echo e(route('panel-blogs.destroy', $blog->id)); ?>"
                                            method="POST" class="formEliminar">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button style="color: black" type="submit"
                                                class="btn btn-danger">Borrar</button>
                                        </form>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>Título</th>
                                <th>Extracto</th>
                                <th>Miniatura</th>
                                <th>Fecha Publicación</th>
                                <th>¿Publicado?</th>
                                <th>Acciones</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da)): ?>
<?php $component = $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da; ?>
<?php unset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da); ?>
<?php endif; ?>
<script>
    (function() {
        'use strict'
        //debemos crear la clase formEliminar dentro del form del boton borrar
        //recordar que cada registro a eliminar esta contenido en un form  
        var forms = document.querySelectorAll('.formEliminar')
        Array.prototype.slice.call(forms)
            .forEach(function(form) {
                form.addEventListener('submit', function(event) {
                    event.preventDefault()
                    event.stopPropagation()
                    Swal.fire({
                        title: '¿Confirma la eliminación del registro?',
                        icon: 'info',
                        showCancelButton: true,
                        confirmButtonColor: '#20c997',
                        cancelButtonColor: '#6c757d',
                        confirmButtonText: 'Confirmar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            this.submit();
                            Swal.fire('¡Eliminado!',
                                'El registro ha sido eliminado exitosamente.', 'success');
                        }
                    })
                }, false)
            })
    })()
</script>
<script>
    $(document).ready(function() {
        $('#myTable').DataTable({
            "pagingType": "simple_numbers",
            "order": [],
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ entradas",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "previous": "Anterior",
                    "next": "Siguiente"
                }
            }
        });
    });
</script><?php /**PATH /var/www/resources/views/panel-blogs/index.blade.php ENDPATH**/ ?>