<?php if (isset($component)) { $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\AppLayout::class, []); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
    <?php $__env->startSection('title', 'Quejas: Inicio'); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('Quejas por Discriminación')); ?>

        </h2>
     <?php $__env->endSlot(); ?>
    <div class="container-fluid px-4 py-3" style="background-color:white; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);">
        <h1 style="font-size: 1.3rem; font-weight:500" class="text-center">Bienvenido, Aquí podrás ver las quejas
            que se hayan enviado</h1>
        <table id="myTable" class="table table-striped" style="width:100%">
            <thead>
                <tr>
                    <th>Nombre completo</th>
                    <th>Correo</th>
                    <th>Teléfono</th>
                    <th>Tipo de queja</th>
                    <th>Documento</th>
                    <th>Incidente</th>
                    <th>Fecha</th>
                    <th>Acción</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $quejas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $queja): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($queja->nombre); ?></td>
                        <td><?php echo e($queja->correo); ?></td>
                        <td><?php echo e($queja->telefono); ?></td>
                        <td><?php echo e($queja->tipo_discriminacion); ?></td>

                        
                        <td>
                            <a href="/incidentes/<?php echo e($queja->formato); ?>" target="_blank"
                                title="Ver documento: <?php echo e(basename($queja->formato)); ?>" 
                                style="display: inline-block; text-align: center;"> 

                                <img src="/imagenes/documento.png" alt="Icono de documento PDF"
                                    style="width: 34px; height: 34px; vertical-align: middle;"> 
                                
                                
                            </a>
                        </td>

                        <td>
                            <?php
                                $limiteCaracteres = 150; // Define cuántos caracteres mostrar inicialmente
                                $textoCompleto = $queja->queja;
                                $esLargo = Illuminate\Support\Str::length($textoCompleto) > $limiteCaracteres;
                                $textoCorto = $esLargo
                                    ? Illuminate\Support\Str::limit($textoCompleto, $limiteCaracteres, '')
                                    : $textoCompleto;
                                // Usamos Str::limit sin '...' porque añadiremos nuestro propio botón/indicador
                            ?>

                            <div class="complaint-text-container">
                                <span class="short-text"><?php echo e($textoCorto); ?></span>
                                
                                <?php if($esLargo): ?>
                                    <span class="full-text" style="display: none;"><?php echo e($textoCompleto); ?></span>
                                    <span class="dots" style="display: inline;">...</span> 
                                    <button type="button" class="read-more-btn"
                                        style="margin-left: 5px; cursor: pointer; background: none; border: none; color: blue; text-decoration: underline; padding: 0;">
                                        Leer más
                                    </button>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td><?php echo e($queja->created_at->format('d/m/Y H:m')); ?></td>
                        <td>
                            <div class="flex justify-center rounded-lg text-lg" role="group">
                                <!-- botón borrar -->
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('borrar-queja')): ?>
                                    <form action="<?php echo e(route('panel-quejas.destroy', $queja->id)); ?>" method="POST"
                                        class="formEliminar">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button style="color: black" type="submit" class="btn btn-danger">Borrar</button>
                                    </form>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            <tfoot>
                <tr>
                    <th>Nombre completo</th>
                    <th>Correo</th>
                    <th>Teléfono</th>
                    <th>Tipo de queja</th>
                    <th>Documento</th>
                    <th>Incidente</th>
                    <th>Acción</th>
                </tr>
            </tfoot>
        </table>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da)): ?>
<?php $component = $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da; ?>
<?php unset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da); ?>
<?php endif; ?>
<script>
    const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
    const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))
    $(document).ready(function() {
        $('#myTable').DataTable({
            "pagingType": "simple_numbers",
            "order": [],
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ entradas",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "previous": "Anterior",
                    "next": "Siguiente"
                }
            }
        });
    });
</script>
<script>
    (function() {
        'use strict'
        var forms = document.querySelectorAll('.formEliminar')
        Array.prototype.slice.call(forms)
            .forEach(function(form) {
                form.addEventListener('submit', function(event) {
                    event.preventDefault()
                    event.stopPropagation()
                    Swal.fire({
                        title: '¿Confirma la eliminación del registro?',
                        icon: 'info',
                        showCancelButton: true,
                        confirmButtonColor: '#20c997',
                        cancelButtonColor: '#6c757d',
                        confirmButtonText: 'Confirmar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            this.submit();
                            Swal.fire('¡Eliminado!',
                                'El registro ha sido eliminado exitosamente.', 'success');
                        }
                    })
                }, false)
            })
    })()
</script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Selecciona todos los botones dentro de los contenedores de texto de quejas
        const toggleButtons = document.querySelectorAll('.complaint-text-container .read-more-btn');

        toggleButtons.forEach(button => {
            // Adjuntamos el listener a cada botón encontrado
            button.addEventListener('click', function() {
                // Encuentra el contenedor padre más cercano del botón clickeado
                const container = this.closest('.complaint-text-container');
                if (!container) return; // Si no se encuentra el contenedor, no hacemos nada

                // Busca los elementos de texto (corto, completo) y los puntos suspensivos DENTRO de ese contenedor
                const shortText = container.querySelector('.short-text');
                const fullText = container.querySelector('.full-text');
                const dots = container.querySelector('.dots');

                // Verifica que todos los elementos necesarios existan
                if (!shortText || !fullText || !dots) return;

                // Comprueba el estado actual: ¿Está visible el texto completo?
                // Usamos offsetParent que es null si el elemento o un ancestro tiene display:none
                const isExpanded = fullText.offsetParent !== null;

                if (isExpanded) {
                    // ---- Acción: COLAPSAR (Mostrar Menos) ----
                    fullText.style.display = 'none'; // Oculta el texto completo
                    shortText.style.display = 'inline'; // Muestra el texto corto
                    dots.style.display = 'inline'; // Muestra los puntos suspensivos
                    this.textContent = 'Leer más'; // Cambia el texto del botón
                } else {
                    // ---- Acción: EXPANDIR (Mostrar Más) ----
                    shortText.style.display = 'none'; // Oculta el texto corto
                    dots.style.display = 'none'; // Oculta los puntos suspensivos
                    fullText.style.display =
                    'inline'; // Muestra el texto completo (usa 'block' si prefieres nueva línea)
                    this.textContent = 'Leer menos'; // Cambia el texto del botón
                }
            });
        });
    });
</script>
<?php /**PATH /var/www/resources/views/panel-quejas/index.blade.php ENDPATH**/ ?>