
<?php $__env->startSection('title', 'Contacto'); ?>
<?php $__env->startSection('meta-description',
    'Contacta al Comité de Igualdad Laboral y No Discriminación de la Secretaría de Planeación
    y Finanzas del Gobierno del Estado de Puebla para cualquier consulta, colaboración o sugerencia relacionada con nuestros
    valores y actividades.'); ?>
<?php $__env->startSection('canonical-url', url()->current()); ?>
<?php $__env->startSection('keywords',
    'Contacto, Comité Igualdad Laboral, No Discriminación, Secretaría de Planeación y Finanzas,
    Gobierno del Estado de Puebla, Igualdad de Género, No Discriminación Laboral, Puebla, Colaboración, Consulta,
    Sugerencia'); ?>
<?php $__env->startSection('og-title', 'Contacto - Comité de Igualdad Laboral y No Discriminación'); ?>
<?php $__env->startSection('og-description',
    'Contacta al Comité de Igualdad Laboral y No Discriminación de la Secretaría de Planeación y
    Finanzas del Gobierno del Estado de Puebla para cualquier consulta, colaboración o sugerencia relacionada con nuestros
    valores y actividades.'); ?>
<?php $__env->startSection('og:url', url()->current()); ?>
<?php $__env->startSection('twitter-title', 'Contacto - Comité de Igualdad Laboral y No Discriminación'); ?>
<?php $__env->startSection('twitter-description',
    'Contacta al Comité de Igualdad Laboral y No Discriminación de la Secretaría de
    Planeación y Finanzas del Gobierno del Estado de Puebla para cualquier consulta, colaboración o sugerencia relacionada
    con nuestros valores y actividades.'); ?>

<?php $__env->startSection('css'); ?>
    <?php echo NoCaptcha::renderJs(); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="contact_section layout_padding"
        style="background-image: url('<?php echo e(asset('imagenes/fondo2.png')); ?>'); background-size: cover; background-repeat: no-repeat;"
        style="background-color: #f7e8e6;">
        <div class="container">
            <div class="heading_container">
                <h1 class="titulo-h1">
                    Contáctanos
                </h1>
            </div>
        </div>
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <div class="container">
                        <form action="<?php echo e(route('panel-quejas.store')); ?>" method="post" enctype="multipart/form-data"
                            novalidate>
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <label for="nombre">Nombre completo:</label>
                                <input type="text" id="nombre" name="nombre"
                                    class="form-control <?php $__errorArgs = ['nombre'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required
                                    value="<?php echo e(old('nombre')); ?>">
                                <?php $__errorArgs = ['nombre'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group">
                                <label for="correo">Correo electrónico:</label>
                                <input type="email" id="correo " name="correo"
                                    class="form-control <?php $__errorArgs = ['correo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('correo')); ?>"
                                    required>
                                <?php $__errorArgs = ['correo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group">
                                <label for="telefono">Número de teléfono:</label>
                                <input type="tel" id="telefono" name="telefono"
                                    class="form-control <?php $__errorArgs = ['telefono'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    value="<?php echo e(old('telefono')); ?>" required>
                                <?php $__errorArgs = ['telefono'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group">
                                <label for="tipo_discriminacion">Tipo de Queja:</label>
                                <select id="tipo_discriminacion" name="tipo_discriminacion" class="form-control" required>
                                    <option value="" disabled selected>Seleccione</option>
                                    <option value="Acoso y Hostigamiento Sexual">Acoso y Hostigamiento Sexual</option>
                                    <option value="Acoso y Hostigamiento Laboral">Acoso y Hostigamiento Laboral
                                    </option>
                                    <option value="Discriminación">Discriminación</option>
                                </select>
                                <?php $__errorArgs = ['tipo_discriminacion'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group">
                                <label for="queja">Describa su queja:</label>
                                <textarea id="queja" name="queja" class="form-control" rows="4" required><?php echo e(old('queja')); ?></textarea>
                                <?php $__errorArgs = ['queja'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div id="descarga-formato" class="form-group" style="display:none;">
                                <p>Descarga el siguiente formato, llénalo y adjúntalo al siguiente apartado.</p>
                                <a id="descargar-formato" class="btn btn-orange" href="#" download>Descargar
                                    formato</a>
                            </div>

                            <div class="form-group">
                                <label for="formato">Adjuntar documento (solo PDF o Word):</label>
                                <input type="file" id="formato" name="formato" class="form-control" accept=".pdf,.docx"
                                    required>
                                <?php $__errorArgs = ['formato'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-12">
                                <?php echo NoCaptcha::display(); ?>

                                <?php $__errorArgs = ['g-recaptcha-response'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group">
                                <label for="Complementarios">Documentos complementarios</label>
                            </div>
                            <div class="form-group">
                                <p>Descarga el siguiente directorio, para que encuentres la instancia más cercana a ti y
                                    puedas continuar con el procedimiento de tu incidente.</p>
                                <a class="btn btn-orange" href="<?php echo e(asset('documentos/Directorio-Protocolo.pdf')); ?>"
                                    download>Descargar directorio</a>
                            </div>

                            <!-- Modal de Bootstrap -->
                            <div class="modal fade" id="avisoPrivacidadModal" tabindex="-1"
                                aria-labelledby="avisoPrivacidadModalLabel" aria-hidden="true">
                                <div class="modal-dialog modal-xl">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="avisoPrivacidadModalLabel">Aviso de Privacidad
                                            </h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Cerrar"></button>
                                        </div>
                                        <div class="modal-body">
                                            <iframe id="avisoPrivacidadIframe" src=""
                                                style="width:100%; height: 80vh; border:none;"></iframe>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Modificación en el Formulario -->
                            <div class="form-group">
                                <label>Aviso de privacidad</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <button type="button" class="btn btn-orange-2 btn-aviso-privacidad mt-0 w-100"
                                            data-tipo="simplificado">Simplificado</button>
                                    </div>
                                    <div class="col-md-6">
                                        <button type="button" class="btn btn-orange-2 btn-aviso-privacidad mt-0 w-100"
                                            data-tipo="integral">Integral</button>
                                    </div>
                                </div>
                            </div>

                            <!-- Botones de documentos extras -->
                            <div class="form-group">
                                <label>Anexos</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <a class="btn btn-orange-2 w-100"
                                            href="<?php echo e(asset('documentos/6. Anexo IX.4. Minuta de Resolución.docx')); ?>"
                                            download>Minuta de Resolución</a>
                                    </div>
                                    <div class="col-md-6">
                                        <a class="btn btn-orange-2 w-100"
                                            href="<?php echo e(asset('documentos/5. Anexo IX.3. Minuta de Entrevista Protocolo y Acuerdo.docx')); ?>"
                                            download>Minuta de Entrevista Protocolo y Acuerdo</a>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <input type="submit" value="Enviar" class="btn btn-orange">
                            </div>
                        </form>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="map_container">
                        <div class="map-responsive">
                            <iframe
                                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d629.3230731027531!2d-98.18690585600862!3d19.03395814966306!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x85cfc7113bf027f9%3A0x5019db208e053e0!2sSecretaria%20de%20Finanzas%20de%20Gobierno%20del%20Puebla!5e0!3m2!1sen!2smx!4v1695752002387!5m2!1sen!2smx"
                                width="600" height="640" frameborder="0" style="border:0; width: 100%; height:100%"
                                allowfullscreen loading="lazy"></iframe>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container my-3 p-4 tarjeta-contacto">
            <p class="text-center">¿Prefieres una comunicación directa? Utiliza la
                información
                de contacto a continuación para hablar con nosotros:
            </p>

            <h4 class="text-center mt-4 mb-3">Información de Contacto</h4>
            <ul class="list-unstyled text-center">
                <li class="mb-3">
                    <i class="fas fa-phone-alt"></i>
                    <strong>Teléfono:</strong>
                    <a href="tel:2222297000" rel="noopener" title="Número de teléfono de contacto">
                        (222) 2 29 70 00 ext. 7142
                    </a>
                </li>
                <li class="mb-3">
                    <i class="fas fa-envelope"></i>
                    <strong>Correo Electrónico:</strong>
                    <a href="mailto:comiteigualdadspf@puebla.gob.mx" title="Envíanos un correo" rel="noopener">
                        comiteigualdadspf@puebla.gob.mx
                    </a>
                </li>
                <li>
                    <i class="fas fa-map-marker-alt"></i>
                    <strong>Ubicación:</strong>
                    Oficinas del Comité de Igualdad Laboral, Tercer Piso, Subsecretaría de Planeación
                </li>
            </ul>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        document.getElementById('tipo_discriminacion').addEventListener('change', function() {
            var descargaFormatoDiv = document.getElementById('descarga-formato');
            var descargarFormatoLink = document.getElementById('descargar-formato');

            if (this.value === 'Acoso y Hostigamiento Sexual') {
                descargaFormatoDiv.style.display = 'block';
                descargarFormatoLink.href =
                    '<?php echo e(asset('documentos/Formato de Queja Acoso, Hostigamiento Sexual.docx')); ?>';
            } else if (this.value === 'Acoso y Hostigamiento Laboral') {
                descargaFormatoDiv.style.display = 'block';
                descargarFormatoLink.href =
                    '<?php echo e(asset('documentos/Formato de Queja Acoso, Hostigamiento Laboral y Discriminación.docx')); ?>';
            } else if (this.value === 'Discriminación') {
                descargaFormatoDiv.style.display = 'block';
                descargarFormatoLink.href =
                    '<?php echo e(asset('documentos/Formato de Queja Acoso, Hostigamiento Laboral y Discriminación.docx')); ?>';
            } else {
                descargaFormatoDiv.style.display = 'none';
            }
        });

        document.querySelectorAll('.btn-aviso-privacidad').forEach(button => {
            button.addEventListener('click', function() {
                var tipo = this.getAttribute('data-tipo');
                var iframe = document.getElementById('avisoPrivacidadIframe');
                if (tipo === 'simplificado') {
                    iframe.src = '<?php echo e(asset('documentos/AvisoPrivacidadSimplificado.pdf')); ?>';
                } else if (tipo === 'integral') {
                    iframe.src = '<?php echo e(asset('documentos/AvisoPrivacidadIntegral.pdf')); ?>';
                }
                var modal = new bootstrap.Modal(document.getElementById('avisoPrivacidadModal'));
                modal.show();
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('componentes.plantilla', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/resources/views/contacto.blade.php ENDPATH**/ ?>