
<?php $__env->startSection('title', $blog->titulo); ?>

<?php $__env->startSection('meta-description', $blog->extracto ?: 'Página del blog ' . $blog->titulo); ?>
<?php $__env->startSection('canonical-url', url()->current()); ?>
<?php $__env->startSection('og-title', $blog->titulo . ' - Comité de Igualdad Laboral y No Discriminación'); ?>
<?php $__env->startSection('keywords',
    $blog->titulo .
    ', Blog, Artículos, Comité Igualdad Laboral, No Discriminación, Secretaría de Planeación y Finanzas,
    Gobierno del Estado de Puebla, Igualdad de Género, No Discriminación Laboral,
    Puebla, Publicaciones, Reflexiones, Noticias, Actualizaciones'); ?>

<?php $__env->startSection('og-description',
    $blog->extracto ?:
    'Lee más sobre ' .
    $blog->titulo .
    ' en nuestra página de
    blogs del Comité de Igualdad Laboral y No Discriminación.'); ?>
<?php $__env->startSection('og:url', url()->current()); ?>
<?php $__env->startSection('og:image', asset($blog->imagen_1)); ?>
<?php $__env->startSection('twitter:image', asset($blog->imagen_1)); ?>
<?php $__env->startSection('twitter-title', $blog->titulo . ' - Comité de Igualdad Laboral y No Discriminación'); ?>

<?php $__env->startSection('twitter-description',
    $blog->extracto ?:
    'Lee más sobre ' .
    $blog->titulo .
    ' en nuestra página de
    blogs del Comité de Igualdad Laboral y No Discriminación.'); ?>
<?php $__env->startSection('meta-keywords',
    $blog->keywords ?:
    'Blog, Artículos, Comité Igualdad Laboral, No Discriminación, Secretaría de
    Planeación y Finanzas, ' . $blog->titulo); ?>
<?php $__env->startSection('og:site_name', $blog->titulo . ' - Comité de Igualdad Laboral y No Discriminación'); ?>

<?php $__env->startSection('css'); ?>
<?php $__env->startSection('css'); ?>
    <style>
        .recommended-blogs {
            margin-top: 30px;
        }

        .recommended-blogs h3 {
            font-size: 1.5em;
            margin-bottom: 20px;
        }

        .card-img-top {
            height: 200px;
            object-fit: cover;
        }
    </style>
    <link rel="stylesheet" href="<?php echo e(asset('css/lightbox.css')); ?>">
    <script src="<?php echo e(asset('js/lightbox.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('jss-inicial'); ?>
    <script src="<?php echo e(asset('js/jquery-3.4.1.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<section>
    <div class="container">
        <h1 class="text-center mb-4 pt-4 titulo-h1">Blog</h1>
        <div class="container text-center">
            <ul class="my-breadcrumb">
                <li><a class="text-dark" href="<?php echo e(url('/')); ?>" rel="noopener" title="Inicio" target="_self">Inicio</a>
                </li>
                <li><a class="text-dark" href="<?php echo e(url('/eventos')); ?>" rel="noopener" title="Blogs"
                        target="_self">Blogs</a></li>
                <li class="text-dark">Blog: <?php echo e($blog->titulo); ?></li>
            </ul>
            <div class="custom-divider">
                <div class="divider-line"></div>
                <div class="divider-arrow">&#10148;</div>
                <div class="divider-line"></div>
            </div>
        </div>
        <div class="container text-center">
            <h2 class="blog-title">
                <?php echo e($blog->titulo); ?>

            </h2>
            <h6 class="text-center">
                <?php echo e(\Carbon\Carbon::parse($blog->published_at)->locale('es')->isoFormat('D [de] MMMM [de] YYYY')); ?>

            </h6>
            <div class="text-justify">
                <span class="extracto">
                    <?php echo e($blog->extracto); ?>

                </span>
            </div>
        </div>
        <div class="row">
            <div class="col-md-4 my-4">
                <img style="width:100%" src="<?php echo e(asset($blog->imagen_1)); ?>" title="<?php echo e($blog->titulo); ?>"
                    alt="<?php echo e($blog->titulo); ?>" />
                <h3 class="pt-3 pb-3">Galeria del blog</h3>
                <div class="gallery row">
                    <?php if($blog->imagen_1): ?>
                        <div class="col-sm-6 col-md-4 col-lg-3 item">
                            <a href="<?php echo e(asset($blog->imagen_1)); ?>" data-lightbox="gallery" title="<?php echo e($blog->titulo); ?>"
                                rel="noopener">
                                <img src="<?php echo e(asset($blog->imagen_1)); ?>" alt="Imagen del blog: <?php echo e($blog->titulo); ?>"
                                    title="Imagen del blog: <?php echo e($blog->titulo); ?>">
                            </a>
                        </div>
                    <?php endif; ?>
                    <?php if($blog->imagen_2): ?>
                        <div class="col-sm-6 col-md-4 col-lg-3 item">
                            <a href="<?php echo e(asset($blog->imagen_2)); ?>" data-lightbox="gallery" title="<?php echo e($blog->titulo); ?>"
                                rel="noopener">
                                <img src="<?php echo e(asset($blog->imagen_2)); ?>" alt="Imagen del blog: <?php echo e($blog->titulo); ?>"
                                    title="Imagen del blog: <?php echo e($blog->titulo); ?>">
                            </a>
                        </div>
                    <?php endif; ?>

                    <?php if($blog->imagen_3): ?>
                        <div class="col-sm-6 col-md-4 col-lg-3 item">
                            <a href="<?php echo e(asset($blog->imagen_3)); ?>" data-lightbox="gallery" title="<?php echo e($blog->titulo); ?>"
                                rel="noopener">
                                <img src="<?php echo e(asset($blog->imagen_3)); ?>" alt="Imagen del blog: <?php echo e($blog->titulo); ?>"
                                    title="Imagen del blog: <?php echo e($blog->titulo); ?>">
                            </a>
                        </div>
                    <?php endif; ?>

                    <?php if($blog->imagen_4): ?>
                        <div class="col-sm-6 col-md-4 col-lg-3 item">
                            <a href="<?php echo e(asset($blog->imagen_4)); ?>" data-lightbox="gallery" title="<?php echo e($blog->titulo); ?>"
                                rel="noopener">
                                <img src="<?php echo e(asset($blog->imagen_4)); ?>" alt="Imagen del blog: <?php echo e($blog->titulo); ?>"
                                    title="Imagen del blog: <?php echo e($blog->titulo); ?>">
                            </a>
                        </div>
                    <?php endif; ?>

                    <?php if($blog->imagen_5): ?>
                        <div class="col-sm-6 col-md-4 col-lg-3 item">
                            <a href="<?php echo e(asset($blog->imagen_5)); ?>" data-lightbox="gallery" title="<?php echo e($blog->titulo); ?>"
                                rel="noopener">
                                <img src="<?php echo e(asset($blog->imagen_5)); ?>" alt="Imagen del blog: <?php echo e($blog->titulo); ?>"
                                    title="Imagen del blog: <?php echo e($blog->titulo); ?>">
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-8">
                <div class="d-flex mt-3">
                    <div class="container">
                        <!-- Botón de compartir en Facebook -->
                        <div class="fb-share-button" data-href="<?php echo e(url()->current()); ?>" data-layout="button_count"
                            data-lazy="true" data-size="large"><a target="_blank"
                                href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(urlencode(url()->current())); ?>"
                                class="fb-xfbml-parse-ignore">Compartir</a>
                        </div>
                    </div>
                    <div class="container">
                        <!-- Botón de compartir en otra red social -->
                        <a href="https://twitter.com/share?ref_src=twsrc%5Etfw" class="twitter-share-button"
                            data-show-count="false" data-size="large">Tweet</a>
                        <script async src="https://platform.twitter.com/widgets.js" charset="utf-8"></script>
                    </div>
                </div>
                <div class="container my-4">
                    <div class="content-container">
                        <p class="item-content">
                        <div dir="auto" style="text-align: justify;"> </div>
                        <div dir="auto" style="text-align: justify;">
                            
                            <?php echo $blog->contenido; ?>

                        </div>
                        <div dir="auto" style="text-align: justify;"> </div>
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-12">
                <!-- Sección de blogs recomendados -->
                <div class="recommended-blogs mt-5">
                    <h3>Últimos Blogs</h3>
                    <div class="row">
                        <?php $__currentLoopData = $recentBlogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recentBlog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-4 mb-4">
                                <div class="card">
                                    <img src="<?php echo e(asset($recentBlog->imagen_1)); ?>" class="card-img-top"
                                        alt="<?php echo e($recentBlog->titulo); ?>">
                                    <div class="card-body">
                                        <h5 class="card-title"><?php echo e($recentBlog->titulo); ?></h5>
                                        <p class="card-text"><?php echo e(Str::limit($recentBlog->excerpt, 100)); ?></p>
                                        <a href="<?php echo e(route('blogs.mostrar', $recentBlog->slug)); ?>"
                                            class="read-more-btn">Leer más</a>
                                    </div>
                                    <div class="card-footer text-muted">
                                        <?php echo e(Carbon\Carbon::parse($recentBlog->published_at)->format('d M Y')); ?>

                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<div id="fb-root"></div>
<script async defer crossorigin="anonymous" src="https://connect.facebook.net/es_LA/sdk.js#xfbml=1&version=v20.0"
    nonce="7M60ODXU"></script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('componentes.plantilla', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/resources/views/blog.blade.php ENDPATH**/ ?>