
<?php $__env->startSection('title', 'Infografías del comité'); ?>
<?php $__env->startSection('meta-description',
    'Descubre las infografías del Comité de Igualdad Laboral y No Discriminación de la
    Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla, que comunican de manera visual nuestros valores y
    compromisos.'); ?>
<?php $__env->startSection('canonical-url', url()->current()); ?>
<?php $__env->startSection('keywords',
    'Infografías, Comité Igualdad Laboral, No Discriminación, Secretaría de Planeación y Finanzas,
    Gobierno del Estado de Puebla, Igualdad de Género, No Discriminación Laboral, Puebla, Sustentabilidad, Visualización de
    Datos'); ?>
<?php $__env->startSection('og-title', 'Infografías - Comité de Igualdad Laboral y No Discriminación'); ?>
<?php $__env->startSection('og-description',
    'Descubre las infografías del Comité de Igualdad Laboral y No Discriminación de la Secretaría
    de Planeación y Finanzas del Gobierno del Estado de Puebla, que comunican de manera visual nuestros valores y
    compromisos.'); ?>
<?php $__env->startSection('og:url', url()->current()); ?>
<?php $__env->startSection('twitter-title', 'Infografías - Comité de Igualdad Laboral y No Discriminación'); ?>
<?php $__env->startSection('twitter-description',
    'Descubre las infografías del Comité de Igualdad Laboral y No Discriminación de la
    Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla, que comunican de manera visual nuestros valores y
    compromisos.'); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/lightbox.css')); ?>">
    <script src="<?php echo e(asset('js/lightbox.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('jss-inicial'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section>
        <div class="lightbox-gallery">
            <div class="container">
                <div class="intro">
                    <h1 class="text-center my-3 titulo-h1">Galeria de Infografías</h1>
                    <p class="text-justify">Descubre nuestras infografías informativas: representaciones visuales que
                        simplifican
                        temas complejos y facilitan la comprensión de información importante.</p>
                </div>
                <div class="row photos">
                    <?php if($infografias->count() > 0): ?>
                        <?php $__currentLoopData = $infografias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $infografia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-sm-6 col-md-4 col-lg-3 item">
                                <div class="infografia-item">
                                    <div class="blog-img">
                                        <a href="/imagenes/infografias-carpeta/<?php echo e($infografia->infografia); ?>"
                                            data-lightbox="photos" title="<?php echo e($infografia->nombre); ?>" rel="noopener">
                                            <img class="img-fluid"
                                                src="/imagenes/infografias-carpeta/miniaturas/<?php echo e($infografia->miniatura); ?>"
                                                loading="lazy" title="<?php echo e($infografia->nombre); ?>"
                                                alt="<?php echo e($infografia->nombre); ?>">
                                        </a>
                                    </div>
                                </div>

                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <p>No hay infografías disponibles.</p>
                    <?php endif; ?>
                    <div class="container text-center">
                        
                        <?php echo e($infografias->onEachSide(1)->links('pagination::bootstrap-4')); ?>

                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('componentes.plantilla', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/resources/views/infografias.blade.php ENDPATH**/ ?>