<header id="navbar">
    <div class="encabezado">
        <div class="logo">
            <a href="<?php echo e(url('/')); ?>">
                <img src="<?php echo e(asset('imagenes/logo-gobierno.png')); ?>" alt="Logo Gobierno">
            </a>
        </div>
        <div class="menu">
            <ul class="navbar-nav">
                <li class="nav-item <?php echo e(request()->is('/') ? 'active' : ''); ?>">
                    <a class="nav-link" href="<?php echo e(url('/')); ?>">Inicio</a>
                </li>
                <li class="nav-item <?php echo e(request()->is('acercade') ? 'active' : ''); ?>">
                    <a class="nav-link" href="<?php echo e(url('/acercade')); ?>">Nosotros</a>
                </li>
                <li class="nav-item <?php echo e(request()->is('documentacion') ? 'active' : ''); ?>">
                    <a class="nav-link" href="<?php echo e(url('/documentacion')); ?>">Documentación</a>
                </li>
                <li class="nav-item dropdown <?php echo e(request()->is('galeria*') ? 'active' : ''); ?>">
                    <a class="nav-link dropdown-toggle" href="#" id="recursosDropdown" role="button">
                        Recursos
                    </a>
                    <div class="dropdown-menu" aria-labelledby="recursosDropdown">
                        <a class="dropdown-item" href="<?php echo e(url('/galeria-infografias')); ?>">Infografías</a>
                        <a class="dropdown-item" href="<?php echo e(url('/galeria-fotografias')); ?>">Fotos</a>
                    </div>
                </li>
                <!-- <li class="nav-item <?php echo e(request()->is('integrantes') ? 'active' : ''); ?>">
                    <a class="nav-link" href="<?php echo e(url('/integrantes')); ?>">Integrantes</a>
                </li> -->
                <li class="nav-item <?php echo e(request()->is('eventos') ? 'active' : ''); ?>">
                    <a class="nav-link" href="<?php echo e(url('/eventos')); ?>">Eventos</a>
                </li>
                <li class="nav-item <?php echo e(request()->is('contacto') ? 'active' : ''); ?>">
                    <a class="nav-link" href="<?php echo e(url('/contacto')); ?>">Contacto</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="#" onclick="openSearchModal()">
                        <i class="fas fa-search"></i>
                    </a>
                </li>
            </ul>
        </div>
    </div>
    
    <div class="encabezado-movil" id="movil-navbar">
        <div class="logo">
            <a href="<?php echo e(url('/')); ?>">
                <img src="<?php echo e(asset('imagenes/logo-gobierno.png')); ?>" alt="Logo Gobierno" class="w-100">
            </a>
        </div>
        <div class="menu">
            <button class="menu-button" id="menuButton">☰</button>
        </div>
    </div>
    <div class="menu-overlay" id="menuOverlay"></div>
    <div class="mobile-menu" id="mobileMenu">
        <div class="logo mb-2">
            <h2>Comité de Igualdad Laboral y No Discriminación</h2>
        </div>
        <ul>
            <li class="<?php echo e(request()->is('/') ? 'active' : ''); ?>">
                <a href="<?php echo e(url('/')); ?>">Inicio</a>
            </li>
            <li class="<?php echo e(request()->is('acercade') ? 'active' : ''); ?>">
                <a href="<?php echo e(url('/acercade')); ?>">Sobre el
                    comité</a>
            </li>
            <li class="<?php echo e(request()->is('documentacion') ? 'active' : ''); ?>">
                <a href="<?php echo e(url('/documentacion')); ?>">Documentación</a>
            </li>
            <li class="<?php echo e(request()->is('galeria-infografias') ? 'active' : ''); ?>">
                <a href="<?php echo e(url('/galeria-infografias')); ?>">Infografías</a>
            </li>
            <li class="<?php echo e(request()->is('galeria-fotografias') ? 'active' : ''); ?>">
                <a href="<?php echo e(url('/galeria-fotografias')); ?>">Fotos</a>
            </li>
            <li class="<?php echo e(request()->is('integrantes') ? 'active' : ''); ?>">
                <a href="<?php echo e(url('/integrantes')); ?>">Integrantes</a>
            </li>
            <li class="<?php echo e(request()->is('eventos') ? 'active' : ''); ?>">
                <a href="<?php echo e(url('/eventos')); ?>">Eventos
                </a>
            </li>
            <li class="<?php echo e(request()->is('contacto') ? 'active' : ''); ?>">
                <a href="<?php echo e(url('/contacto')); ?>">Contacto
                </a>
            </li>
        </ul>
    </div>
</header>

<!-- Botón flotante y menú móvil -->



<?php /**PATH /var/www/resources/views/componentes/headers.blade.php ENDPATH**/ ?>