
<?php $__env->startSection('title', 'Galeria fotográfica del comité'); ?>
<?php $__env->startSection('meta-description',
    'Explora la galería fotográfica de los eventos del Comité de Igualdad Laboral y No
    Discriminación de la Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla, donde celebramos nuestros
    logros y promovemos la inclusión y la igualdad.'); ?>
<?php $__env->startSection('canonical-url', url()->current()); ?>
<?php $__env->startSection('keywords',
    'Galería Fotográfica, Eventos, Comité Igualdad Laboral, No Discriminación, Secretaría de Planeación
    y Finanzas, Gobierno del Estado de Puebla, Igualdad de Género, No Discriminación Laboral, Puebla, Inclusión,
    Celebraciones'); ?>
<?php $__env->startSection('og-title', 'Galería Fotográfica - Eventos del Comité de Igualdad Laboral y No Discriminación'); ?>
<?php $__env->startSection('og-description',
    'Explora la galería fotográfica de los eventos del Comité de Igualdad Laboral y No
    Discriminación de la Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla, donde celebramos nuestros
    logros y promovemos la inclusión y la igualdad.'); ?>
<?php $__env->startSection('og:url', url()->current()); ?>
<?php $__env->startSection('twitter-title', 'Galería Fotográfica - Eventos del Comité de Igualdad Laboral y No Discriminación'); ?>
<?php $__env->startSection('twitter-description',
    'Explora la galería fotográfica de los eventos del Comité de Igualdad Laboral y No
    Discriminación de la Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla, donde celebramos nuestros
    logros y promovemos la inclusión y la igualdad.'); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/lightbox.css')); ?>">
    <script src="<?php echo e(asset('js/lightbox.js')); ?>"></script>
<?php $__env->stopSection(); ?> 
<?php $__env->startSection('jss-inicial'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section>
        <div class="lightbox-gallery">
            <div class="container">
                <div class="intro">
                    <h1 class="text-center my-3 titulo-h1">Galeria de fotografías</h1>
                    <p class="text-justify">
                        Explora nuestra galería de fotografías del Comité de Igualdad Laboral
                        y No Discriminación para descubrir momentos inspiradores y acciones
                        que promueven la igualdad y la diversidad en el entorno laboral.
                    </p>

                    <div class="form-group-fotos">
                        <label for="month-select" class="form-label">Elija el mes:</label>
                        <select id="month-select" class="form-select">
                            <option value="">Seleccione un mes</option>
                            <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $monthNumber => $monthName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($monthNumber); ?>"><?php echo e($monthName); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="fotos-navegacion" id="fotos-navegacion">
                    <?php if($fechasPaginadas->isEmpty()): ?>
                        <p>No hay fotos disponibles.</p>
                    <?php else: ?>
                        <?php $__currentLoopData = $fechasPaginadas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mesAnio => $fotosPorMesAnio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $mesAnioTraducido = Carbon\Carbon::parse($mesAnio)
                                    ->locale('es')
                                    ->isoFormat('MMMM [de] YYYY');

                                $fotosDelMes = App\Models\Fotografia::whereYear(
                                    'fecha',
                                    Carbon\Carbon::parse($mesAnio)->year,
                                )
                                    ->whereMonth('fecha', Carbon\Carbon::parse($mesAnio)->month)
                                    ->orderBy('nombre_evento')
                                    ->orderBy('nombre_archivo')
                                    ->get();

                                $eventos = $fotosDelMes->groupBy('nombre_evento');
                            ?>

                            <div class="mes">
                                <h2 class="text-capitalize"><?php echo e($mesAnioTraducido); ?></h2>

                                <?php $__currentLoopData = $eventos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nombreEvento => $fotosPorEvento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <h3 class="text-capitalize text-black"><?php echo e($nombreEvento); ?></h3>
                                    <div class="row photos" id="<?php echo e(Str::slug($mesAnio)); ?>">
                                        <?php $__currentLoopData = $fotosPorEvento; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $foto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $extension = pathinfo($foto->nombre_archivo, PATHINFO_EXTENSION);
                                                $extensionesImagen = ['jpeg', 'jpg', 'png', 'svg'];
                                                $extensionesVideo = ['mp4', 'mov', 'avi', 'wmv'];
                                            ?>
                                            <?php if(in_array($extension, $extensionesImagen)): ?>
                                                <div class="col-sm-6 col-md-4 col-lg-3 item">
                                                    <div class="fotografia-item">
                                                        <div class="blog-img">
                                                            <a href="imagenes/fotos-carpeta/<?php echo e($foto->nombre_archivo); ?>"
                                                                data-lightbox="photos" title="<?php echo e($nombreEvento); ?>"
                                                                rel="noopener">
                                                                <img class="img-fluid"
                                                                    src="imagenes/fotos-carpeta/<?php echo e($foto->nombre_archivo); ?>"
                                                                    loading="lazy" alt="<?php echo e($nombreEvento); ?>"
                                                                    title="<?php echo e($nombreEvento); ?>">
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php elseif(in_array($extension, $extensionesVideo)): ?>
                                                <div class="col-sm-6 col-md-4 col-lg-3">
                                                    <video controls class="video-comite-fotos" >
                                                        <source src="imagenes/fotos-carpeta/<?php echo e($foto->nombre_archivo); ?>"
                                                            type="video/<?php echo e($extension); ?>">
                                                        Tu navegador no soporta la reproducción de videos.
                                                    </video>
                                                </div>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    <div class="container" style="display:flex; justify-content:center">
                        <?php echo e($fechasPaginadas->links('pagination::bootstrap-4')); ?>

                    </div>
                </div>

                <div class="fotos-mes" id="fotos-mes" style="display: none; position: relative;">
                    
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        document.getElementById('month-select').addEventListener('change', function() {
            // Obtén el valor del select
            let monthYear = this.value;

            // Verifica que el valor no esté vacío
            if (monthYear) {
                fetch(`/mostrar_fotos_por_mes/${monthYear}`)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error('La solicitud ha fallado');
                        }
                        return response.text();
                    })
                    .then(data => {
                        // Muestra el contenedor de fotos y oculta el contenedor de navegación
                        document.getElementById('fotos-navegacion').style.display = 'none';
                        document.getElementById('fotos-mes').innerHTML = data;
                        document.getElementById('fotos-mes').style.display = 'block';
                    })
                    .catch(error => {
                        console.error('Error:', error);
                    });
            } else {
                // Si el valor es vacío o nulo, oculta el contenedor de fotos por mes y muestra el de navegación
                document.getElementById('fotos-mes').style.display = 'none';
                document.getElementById('fotos-navegacion').style.display = 'block';
            }
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('componentes.plantilla', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/resources/views/galeria.blade.php ENDPATH**/ ?>