<?php if (isset($component)) { $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\AppLayout::class, []); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
    <?php $__env->startSection('title', 'Infografías: Inicio'); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('Infografías del Comité')); ?>

        </h2>
     <?php $__env->endSlot(); ?>
    <?php if($message = Session::get('success')): ?>
    <script>
        Swal.fire({
            icon: 'success',
            title: '<?php echo e($message); ?>'
        })
    </script>
    <?php endif; ?>
    <div class="container py-12 mx-auto">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="" style="background-color: white; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);">
                <div class="container ">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('crear-infografia')): ?>
                    <a href="<?php echo e(route('panel-infografias.create')); ?>" title="Botón de Subir infografía">
                        <button class="btn btn-primary mt-3 mb-3 ml-3">Subir
                            nueva</button>
                    </a>
                    <?php endif; ?>
                </div>
                <div class="container table-responsive">
                    <?php if(session('message')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session('message')); ?>

                    </div>
                    <?php endif; ?>
                    <table id="myTable" class="table table-striped" style="width:100%">
                        <thead>
                            <tr>
                                <th>Nombre</th>
                                <th>Fecha de publicación</th>
                                <th>Infografia</th>
                                <th>Fecha Subido</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if($infografias): ?>
                            <?php $__currentLoopData = $infografias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $infografia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($infografia->nombre); ?></td>
                                <td>
                                    <?php echo e(\Carbon\Carbon::parse($infografia->fecha_publicacion)->locale('es')->translatedFormat('d \d\e F \d\e Y')); ?>

                                </td>
                                <td>
                                    <a href="imagenes/infografias-carpeta/<?php echo e($infografia->infografia); ?>"
                                        target="_blank" rel="noopener"
                                        title="Enlace a <?php echo e($infografia->nombre); ?>">
                                        <img src="imagenes/infografias-carpeta/<?php echo e($infografia->infografia); ?>"
                                            class="img-thumbnail" title="Infografía: <?php echo e($infografia->nombre); ?>"
                                            alt="Infografía de <?php echo e($infografia->nombre); ?>"
                                            style="max-height: 100px">
                                    </a>
                                </td>
                                <td>
                                    <?php echo e(\Carbon\Carbon::parse($infografia->created_at)->locale('es')->translatedFormat('d \d\e F \d\e Y')); ?>

                                </td>
                                <td>
                                    <div class="flex justify-center rounded-lg text-lg" role="group">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('editar-infografia')): ?>
                                        <a href="<?php echo e(route('panel-infografias.edit', $infografia->id)); ?>"
                                            class="">
                                            <button class="btn btn-secondary">
                                                Editar
                                            </button>
                                        </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('borrar-infografia')): ?>
                                        <form
                                            action="<?php echo e(route('panel-infografias.destroy', $infografia->id)); ?>"
                                            method="POST" class="formEliminar">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button style="color: black" type="submit"
                                                class="btn btn-danger">Borrar</button>
                                        </form>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>Nombre</th>

                                <th>Fecha de publicación</th>
                                <th>Infografia</th>
                                <th>Fecha Subido</th>
                                <th>Acciones</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
                
        </div>
    </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da)): ?>
<?php $component = $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da; ?>
<?php unset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da); ?>
<?php endif; ?>
<script>
    (function() {
        'use strict'
        //debemos crear la clase formEliminar dentro del form del boton borrar
        //recordar que cada registro a eliminar esta contenido en un form  
        var forms = document.querySelectorAll('.formEliminar')
        Array.prototype.slice.call(forms)
            .forEach(function(form) {
                form.addEventListener('submit', function(event) {
                    event.preventDefault()
                    event.stopPropagation()
                    Swal.fire({
                        title: '¿Confirma la eliminación del registro?',
                        icon: 'info',
                        showCancelButton: true,
                        confirmButtonColor: '#20c997',
                        cancelButtonColor: '#6c757d',
                        confirmButtonText: 'Confirmar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            this.submit();
                            Swal.fire('¡Eliminado!',
                                'El registro ha sido eliminado exitosamente.', 'success');
                        }
                    })
                }, false)
            })
    })()
</script>
<script>
    $(document).ready(function() {
        $('#myTable').DataTable({
            "pagingType": "simple_numbers",
            "order": [],
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ entradas",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "previous": "Anterior",
                    "next": "Siguiente"
                }
            }
        });
    });
</script><?php /**PATH /var/www/resources/views/panel-infografias/index.blade.php ENDPATH**/ ?>