
<?php $__env->startSection('title', 'Eventos del comité'); ?>
<?php $__env->startSection('meta-description',
    'Descubre los eventos y blogs del Comité de Igualdad Laboral y No Discriminación de la
    Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla, donde mantenemos informados a nuestros
    colaboradores y público en general sobre nuestras actividades y reflexiones.'); ?>
<?php $__env->startSection('canonical-url', url()->current()); ?>
<?php $__env->startSection('keywords',
    'Eventos, Blogs, Comité Igualdad Laboral, No Discriminación, Secretaría de Planeación y Finanzas,
    Gobierno del Estado de Puebla, Igualdad de Género, No Discriminación Laboral, Puebla, Calendario de Eventos,
    Publicaciones, Reflexiones'); ?>
<?php $__env->startSection('og-title', 'Eventos y Blogs - Comité de Igualdad Laboral y No Discriminación'); ?>
<?php $__env->startSection('og-description',
    'Descubre los eventos y blogs del Comité de Igualdad Laboral y No Discriminación de la
    Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla, donde mantenemos informados a nuestros
    colaboradores y público en general sobre nuestras actividades y reflexiones.'); ?>
<?php $__env->startSection('og:url', url()->current()); ?>
<?php $__env->startSection('twitter-title', 'Eventos y Blogs - Comité de Igualdad Laboral y No Discriminación'); ?>
<?php $__env->startSection('twitter-description',
    'Descubre los eventos y blogs del Comité de Igualdad Laboral y No Discriminación de la
    Secretaría de Planeación y Finanzas del Gobierno del Estado de Puebla, donde mantenemos informados a nuestros
    colaboradores y público en general sobre nuestras actividades y reflexiones.'); ?>

<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section id="eventos" class="text-center">
        <div class="container py-4">
            <h1 class="titulo-h1">Eventos</h1>
        </div>
        <div class="container">
            <div class="row">
                <div class="carousel slide" data-ride="carousel" id="event-carousel" data-interval="false">
                    <div class="carousel-inner">
                        <?php if($eventos->count() > 0): ?>
                            <?php $__currentLoopData = $eventos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mes => $eventosDelMes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="carousel-item <?php echo e($mes == $mesActual ? 'active' : ''); ?>">
                                    <div class="event-container">
                                        <div class="event-header">
                                            <div class="event-month-year">
                                                <?php echo e(ucfirst(Carbon\Carbon::parse($mes . '-01')->isoFormat('MMMM YYYY'))); ?>

                                            </div>
                                        </div>
                                        <?php $__currentLoopData = $eventosDelMes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $evento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="container event-item">
                                                <div class="row">
                                                    <div class="col-md-2 event-date">
                                                        <div class="day">
                                                            <?php echo e(\Carbon\Carbon::parse($evento->fecha_evento)->day); ?>

                                                        </div>
                                                        <span
                                                            class="weekday"><?php echo e(\Carbon\Carbon::parse($evento->fecha_evento)->locale('es')->isoFormat('dddd')); ?></span>
                                                    </div>
                                                    <div class="col-md-10 event-desc">
                                                        <div class="title"><?php echo e($evento->titulo); ?></div>
                                                        <div class="subtitle">
                                                            <?php echo e($evento->subtitulo); ?>

                                                        </div>
                                                        <p><?php echo e($evento->descripcion); ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <p>No hay eventos disponibles.</p>
                        <?php endif; ?>
                    </div>
                    <!-- Carousel Slide Container -->
                    <a class="carousel-control-prev eventos-carousel-control" href="#event-carousel" role="button"
                        data-bs-slide="prev">
                        <span class="carousel-control-prev-icon eventos-icon" aria-hidden="true"></span>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next eventos-carousel-control" href="#event-carousel" role="button"
                        data-bs-slide="next">
                        <span class="carousel-control-next-icon eventos-icon" aria-hidden="true"></span>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
        </div>
        <!-- Container -->
    </section>
    <section class="blog-details" id="blogs">
        <div class="container pt-5">
            <div class="container">
                <div class="row">
                    <h1 class="titulo-h1">Blogs</h1>
                </div>
            </div>
            <div class="row">
                <?php if($blogs->count() > 0): ?>
                    <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
                            <div class="blog-card">
                                <div class="blog-card-img">
                                    <a href="<?php echo e(route('blogs.mostrar', $blog->slug)); ?>" title="<?php echo e($blog->titulo); ?>"
                                        rel="noopener" target="_self"><img src="<?php echo e(asset($blog->imagen_1)); ?>"
                                            alt="Imagen del blog <?php echo e($blog->titulo); ?>"
                                            title="Imagen del blog <?php echo e($blog->titulo); ?>">
                                    </a>
                                </div>
                                <div class="blog-card-text-area">
                                    <div class="blog-date">
                                        <ul>
                                            <li>
                                                <i class="fas fa-user"></i>
                                                Por
                                                <a href="<?php echo e(url('/integrantes')); ?>" target="_self" rel="noopener"
                                                    title="Integrantes">
                                                    Admin
                                                </a>
                                            </li>
                                            <li>
                                                <i class="far fa-calendar-alt"></i>
                                                <?php echo e(\Carbon\Carbon::parse($blog->published_at)->locale('es')->isoFormat('DD MMM YYYY')); ?>

                                            </li>
                                        </ul>
                                    </div>
                                    <h4 class="titulo-blog-tarjeta">
                                        <a href="<?php echo e(route('blogs.mostrar', $blog->slug)); ?>" title="<?php echo e($blog->titulo); ?>"
                                            rel="noopener" target="_self">
                                            <?php echo e($blog->titulo); ?>

                                        </a>
                                    </h4>
                                    <p class="extracto-tarjeta">
                                        <?php echo e($blog->extracto); ?>

                                    </p>
                                </div>
                                <div class="container d-flex justify-content-center">
                                    <a class="read-more-btn" href="<?php echo e(route('blogs.mostrar', $blog->slug)); ?>"
                                        title="<?php echo e($blog->titulo); ?>" rel="noopener" target="_self">
                                        Leer Más
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <div class="container text-center mt-2">
                        
                        <?php echo e($blogs->onEachSide(1)->links('pagination::bootstrap-4')); ?>

                    </div>
                <?php else: ?>
                    <h4 class="text-center">No hay blogs disponibles.</h4>
                <?php endif; ?>

            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('componentes.plantilla', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/resources/views/eventos.blade.php ENDPATH**/ ?>