<?php if (isset($component)) { $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\AppLayout::class, []); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
    <?php $__env->startSection('title', 'Fotografías: Inicio'); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="h5 text-dark">
            <?php echo e(__('Fotografías del Comité')); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <?php if($message = Session::get('success')): ?>
        <script>
            Swal.fire({
                icon: 'success',
                title: '<?php echo e($message); ?>'
            })
        </script>
    <?php endif; ?>

    <div class="container">
        <div class="bg-white shadow p-4 rounded table-responsive">
            <div class="mb-3">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('crear-fotografia')): ?>
                    <a href="<?php echo e(route('panel-fotografias.create')); ?>">
                        <button class="btn btn-primary">
                            Subir fotos
                        </button>
                    </a>
                <?php endif; ?>
            </div>
            <table id="myTable" class="table table-striped table-bordered" style="width:100%">
                <thead>
                    <tr>
                        <th>Evento</th>
                        <th>Mes</th>
                        <th>Año</th>
                        <th>Foto</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($fotografias): ?>
                        <?php $__currentLoopData = $fotografias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $foto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($foto->nombre_evento); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($foto->fecha)->locale('es')->translatedFormat('F')); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($foto->fecha)->format('Y')); ?></td>
                                <td>
                                    <?php
                                        $extension = pathinfo($foto->nombre_archivo, PATHINFO_EXTENSION);
                                        $extensionesImagen = ['jpeg', 'jpg', 'png', 'svg'];
                                        $extensionesVideo = ['mp4', 'mov', 'avi', 'wmv'];
                                    ?>

                                    <?php if(in_array($extension, $extensionesImagen)): ?>
                                        <a href="imagenes/fotos-carpeta/<?php echo e($foto->nombre_archivo); ?>" target="_blank"
                                            rel="noopener">
                                            <img src="imagenes/fotos-carpeta/<?php echo e($foto->nombre_archivo); ?>"
                                                class="img-thumbnail" style="max-height: 100px">
                                        </a>
                                    <?php elseif(in_array($extension, $extensionesVideo)): ?>
                                        <video controls style="max-height: 100px">
                                            <source src="imagenes/fotos-carpeta/<?php echo e($foto->nombre_archivo); ?>"
                                                type="video/<?php echo e($extension); ?>">
                                            Tu navegador no soporta la reproducción de videos.
                                        </video>
                                    <?php endif; ?>
                                </td>
                                
                                <td>
                                    <div class="d-flex justify-content-center gap-2">
                                        
                                        <!-- Botón para abrir el modal de edición -->
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('editar-fotografia')): ?>
                                            <button class="btn btn-secondary btnEditar" data-bs-toggle="modal"
                                                data-bs-target="#modalEditar" data-id="<?php echo e($foto->id); ?>"
                                                data-nombre="<?php echo e($foto->nombre_evento); ?>" data-fecha="<?php echo e($foto->fecha); ?>"
                                                data-imagen="imagenes/fotos-carpeta/<?php echo e($foto->nombre_archivo); ?>">
                                                Editar
                                            </button>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('borrar-fotografia')): ?>
                                            <form action="<?php echo e(route('panel-fotografias.destroy', $foto->id)); ?>"
                                                method="POST" class="d-inline formEliminar">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-danger">Borrar</button>
                                            </form>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </tbody>
                <tfoot>
                    <tr>
                        <th>Evento</th>
                        <th>Mes</th>
                        <th>Año</th>
                        <th>Foto</th>
                        <th>Acciones</th>
                    </tr>
                </tfoot>
            </table>
            <div class="modal fade" id="modalEditar" tabindex="-1" aria-labelledby="modalEditarLabel"
                aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="modalEditarLabel">Editar Fotografía</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <form id="formEditar" action="<?php echo e(route('panel-fotografias.update', 0)); ?>" method="POST"
                                enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>
                                <div class="mb-3">
                                    <label for="nombre_evento" class="form-label">Nombre del evento</label>
                                    <input type="text" class="form-control" id="nombre_evento" name="nombre_evento"
                                        required>
                                </div>
                                <div class="mb-3">
                                    <label for="fecha" class="form-label">Fecha</label>
                                    <input type="date" class="form-control" id="fecha" name="fecha" required>
                                </div>
                                <div class="mb-3">
                                    <label for="imagen_actual" class="form-label">Imagen actual</label>
                                    <img id="imagen_actual" src="" class="img-fluid mb-3">
                                </div>
                                <div class="mb-3">
                                    <label for="nombre_archivo" class="form-label">Actualizar fotografía</label>
                                    <input type="file" class="form-control" id="nombre_archivo"
                                        name="nombre_archivo">
                                </div>
                                <button type="submit" class="btn btn-primary">Guardar cambios</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da)): ?>
<?php $component = $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da; ?>
<?php unset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da); ?>
<?php endif; ?>

<!-- Scripts -->
<script>
    $(document).ready(function() {
        $('#myTable').DataTable({
            "pagingType": "simple_numbers",
            "order": [],
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ entradas",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "previous": "Anterior",
                    "next": "Siguiente"
                }
            }
        });
    });
</script>
<script>
    (function() {
        'use strict'
        //debemos crear la clase formEliminar dentro del form del boton borrar
        //recordar que cada registro a eliminar esta contenido en un form  
        var forms = document.querySelectorAll('.formEliminar')
        Array.prototype.slice.call(forms)
            .forEach(function(form) {
                form.addEventListener('submit', function(event) {
                    event.preventDefault()
                    event.stopPropagation()
                    Swal.fire({
                        title: '¿Confirma la eliminación del registro?',
                        icon: 'info',
                        showCancelButton: true,
                        confirmButtonColor: '#20c997',
                        cancelButtonColor: '#6c757d',
                        confirmButtonText: 'Confirmar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            this.submit();
                            Swal.fire('¡Eliminado!',
                                'El registro ha sido eliminado exitosamente.', 'success');
                        }
                    })
                }, false)
            })
    })()
</script>
<script>
    $(document).ready(function() {
        $('#modalEditar').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget); // Botón que activó el modal
            var id = button.data('id');
            var nombre = button.data('nombre');
            var fecha = button.data('fecha');
            var imagen = button.data('imagen');

            var modal = $(this);
            modal.find('.modal-title').text('Editar Fotografía: ' + nombre);
            modal.find('#nombre_evento').val(nombre);
            modal.find('#fecha').val(fecha);
            modal.find('#imagen_actual').attr('src', imagen);

            var formAction = "<?php echo e(url('panel-fotografias')); ?>/" + id;
            modal.find('#formEditar').attr('action', formAction);
        });
    });
</script>
<?php /**PATH /var/www/resources/views/panel-fotografias/index.blade.php ENDPATH**/ ?>