#!/bin/bash

echo "🔄 Reiniciando Laravel y compilando assets..."

echo "1️⃣ Parando y eliminando contenedores anteriores"
docker-compose down

echo "2️⃣ Levantando contenedores con build limpio"
docker-compose up -d --build

echo "3️⃣ Ejecutando npm install y npm run build"
docker exec -it node npm install
docker exec -it node npm run build

echo "4️⃣ (Opcional) Sirviendo Laravel en puerto 8000"
docker exec -it laravel_app php artisan serve --host=0.0.0.0 --port=8000

echo "✅ Laravel reiniciado y frontend compilado"
