#!/bin/bash

echo "♻️ Reiniciando Laravel y compilando assets..."

# Detener y levantar contenedores (opcional, puedes comentar si ya están corriendo)
# docker-compose down
# docker-compose up -d --build

echo "🔑 Generando clave de la app (si no está creada)"
docker exec -it laravel_app php artisan key:generate

echo "📦 Ejecutando 'composer install' (Laravel)"
docker exec -it laravel_app composer install

echo "📦 Ejecutando 'npm install' (Node)"
docker exec -it node npm install

echo "🛠 Compilando assets con Laravel Mix (modo dev)"
docker exec -it node npm run dev

echo "✅ Laravel reiniciado y assets compilados."
