#!/bin/bash

echo "🚀 Limpiando cachés de Laravel dentro del contenedor 'laravel_app'..."

docker exec -it laravel_app php artisan view:clear
docker exec -it laravel_app php artisan config:clear
docker exec -it laravel_app php artisan route:clear
docker exec -it laravel_app php artisan cache:clear

echo "🧹 Borrando archivos en bootstrap/cache/"
docker exec -it laravel_app bash -c "rm -rf bootstrap/cache/*"

echo "⚡ Ejecutando optimización opcional"
docker exec -it laravel_app php artisan optimize

echo "✅ Cachés limpiadas y Laravel listo para trabajar."
