<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\InfografiaController;
use App\Http\Controllers\InicioController;
use App\Http\Controllers\QuejaController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\FotografiaController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\EventoController;
use App\Http\Controllers\RolController;
use App\Http\Controllers\UserController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [InicioController::class, 'index'])->name('inicio');

Route::get('/acercade', function () {
    return view('acercade');
})->name('acercade');

Route::get('/blog', function () {
    return view('blog');
})->name('blog');

Route::get('/galeria-infografias', function () {
    return view('infografias');
})->name('infografias');

Route::get('/galeria-fotografias', function () {
    return view('galeria');
})->name('galeria');

Route::get('/integrantes', function () {
    return view('integrantes');
})->name('integrantes');

Route::get('/contacto', function () {
    return view('contacto');
})->name('contacto');

Route::get('/documentacion', function () {
    return view('documentacion');
})->name('documentacion');

Route::get('/blogs', function () {
    return redirect('/eventos#blogs');
});

Route::get('/register', function () {
    return redirect('/login');
});

Route::group(['middleware' => ['auth']], function () {
    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    // Panel de Quejas
    Route::resource('panel-quejas', QuejaController::class);

    // Panel de Administración
    Route::resource('panel-infografias', InfografiaController::class);
    Route::resource('panel-fotografias', FotografiaController::class);
    Route::resource('panel-blogs', BlogController::class);
    Route::resource('panel-eventos', EventoController::class);
    Route::resource('roles', RolController::class);
    Route::resource('usuarios', UserController::class);
    Route::resource('blogs', BlogController::class)->except(['show']);
});

// Ruta para mostrar eventos y blogs
Route::get('/eventos', [EventoController::class, 'mostrarEventos'])->name('eventos');
Route::get('/blogs/{slug}', [BlogController::class, 'mostrarBlogs'])->name('blogs.mostrar');

// Ruta para mostrar infografías
Route::get('/galeria-infografias', [InfografiaController::class, 'mostrarInfografias'])->name('mostrarInfografias');

// Ruta para mostrar fotografias
Route::get('/galeria-fotografias', [FotografiaController::class, 'mostrarFotos'])->name('mostrarFotos');
Route::get('/mostrar_fotos_por_mes/{mes}', [FotografiaController::class, 'mostrarFotosPorMes']);

// Ruta para almacenar quejas (pública)
Route::post('panel-quejas', [QuejaController::class, 'store'])->name('panel-quejas.store');

// Rutas originales
// Route::get('/', function () {
//     return view('welcome');
// });

// Route::middleware([
//     'auth:sanctum',
//     config('jetstream.auth_session'),
//     'verified'
// ])->group(function () {
//     Route::get('/dashboard', function () {
//         return view('dashboard');
//     })->name('dashboard');
// });
