<x-app-layout>
    @section('title', 'Quejas: Inicio')
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Quejas por Discriminación') }}
        </h2>
    </x-slot>
    <div class="container-fluid px-4 py-3" style="background-color:white; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);">
        <h1 style="font-size: 1.3rem; font-weight:500" class="text-center">Bienvenido, Aquí podrás ver las quejas
            que se hayan enviado</h1>
        <table id="myTable" class="table table-striped" style="width:100%">
            <thead>
                <tr>
                    <th>Nombre completo</th>
                    <th>Correo</th>
                    <th>Teléfono</th>
                    <th>Tipo de queja</th>
                    <th>Documento</th>
                    <th>Incidente</th>
                    <th>Fecha</th>
                    <th>Acción</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($quejas as $queja)
                    <tr>
                        <td>{{ $queja->nombre }}</td>
                        <td>{{ $queja->correo }}</td>
                        <td>{{ $queja->telefono }}</td>
                        <td>{{ $queja->tipo_discriminacion }}</td>

                        {{-- <td><a href="/incidentes/{{ $queja->formato }}" target="_blank">
                                <img class="justify-items-center" src="/imagenes/documento.png" alt="imagen de PDF"
                                    width="5%">
                                {{ basename($queja->formato) }}
                            </a></td>
                        <td>{{ $queja->queja }}</td> --}}
                        <td>
                            <a href="/incidentes/{{ $queja->formato }}" target="_blank"
                                title="Ver documento: {{ basename($queja->formato) }}" {{-- Tooltip con el nombre del archivo al pasar el ratón --}}
                                style="display: inline-block; text-align: center;"> {{-- Estilo para centrar el icono --}}

                                <img src="/imagenes/documento.png" alt="Icono de documento PDF"
                                    style="width: 34px; height: 34px; vertical-align: middle;"> {{-- Tamaño fijo para el icono --}}
                                {{-- Ya no se muestra el nombre del archivo aquí abajo --}}
                                {{-- {{ basename($queja->formato) }} --}}
                            </a>
                        </td>

                        <td>
                            @php
                                $limiteCaracteres = 150; // Define cuántos caracteres mostrar inicialmente
                                $textoCompleto = $queja->queja;
                                $esLargo = Illuminate\Support\Str::length($textoCompleto) > $limiteCaracteres;
                                $textoCorto = $esLargo
                                    ? Illuminate\Support\Str::limit($textoCompleto, $limiteCaracteres, '')
                                    : $textoCompleto;
                                // Usamos Str::limit sin '...' porque añadiremos nuestro propio botón/indicador
                            @endphp

                            <div class="complaint-text-container">
                                <span class="short-text">{{ $textoCorto }}</span>
                                {{-- El texto completo se oculta inicialmente si es largo --}}
                                @if ($esLargo)
                                    <span class="full-text" style="display: none;">{{ $textoCompleto }}</span>
                                    <span class="dots" style="display: inline;">...</span> {{-- Puntos suspensivos mostrados inicialmente --}}
                                    <button type="button" class="read-more-btn"
                                        style="margin-left: 5px; cursor: pointer; background: none; border: none; color: blue; text-decoration: underline; padding: 0;">
                                        Leer más
                                    </button>
                                @endif
                            </div>
                        </td>
                        <td>{{ $queja->created_at->format('d/m/Y H:m') }}</td>
                        <td>
                            <div class="flex justify-center rounded-lg text-lg" role="group">
                                <!-- botón borrar -->
                                @can('borrar-queja')
                                    <form action="{{ route('panel-quejas.destroy', $queja->id) }}" method="POST"
                                        class="formEliminar">
                                        @csrf
                                        @method('DELETE')
                                        <button style="color: black" type="submit" class="btn btn-danger">Borrar</button>
                                    </form>
                                @endcan
                            </div>
                        </td>
                    </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr>
                    <th>Nombre completo</th>
                    <th>Correo</th>
                    <th>Teléfono</th>
                    <th>Tipo de queja</th>
                    <th>Documento</th>
                    <th>Incidente</th>
                    <th>Acción</th>
                </tr>
            </tfoot>
        </table>
    </div>
</x-app-layout>
<script>
    const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
    const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))
    $(document).ready(function() {
        $('#myTable').DataTable({
            "pagingType": "simple_numbers",
            "order": [],
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ entradas",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "previous": "Anterior",
                    "next": "Siguiente"
                }
            }
        });
    });
</script>
<script>
    (function() {
        'use strict'
        var forms = document.querySelectorAll('.formEliminar')
        Array.prototype.slice.call(forms)
            .forEach(function(form) {
                form.addEventListener('submit', function(event) {
                    event.preventDefault()
                    event.stopPropagation()
                    Swal.fire({
                        title: '¿Confirma la eliminación del registro?',
                        icon: 'info',
                        showCancelButton: true,
                        confirmButtonColor: '#20c997',
                        cancelButtonColor: '#6c757d',
                        confirmButtonText: 'Confirmar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            this.submit();
                            Swal.fire('¡Eliminado!',
                                'El registro ha sido eliminado exitosamente.', 'success');
                        }
                    })
                }, false)
            })
    })()
</script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Selecciona todos los botones dentro de los contenedores de texto de quejas
        const toggleButtons = document.querySelectorAll('.complaint-text-container .read-more-btn');

        toggleButtons.forEach(button => {
            // Adjuntamos el listener a cada botón encontrado
            button.addEventListener('click', function() {
                // Encuentra el contenedor padre más cercano del botón clickeado
                const container = this.closest('.complaint-text-container');
                if (!container) return; // Si no se encuentra el contenedor, no hacemos nada

                // Busca los elementos de texto (corto, completo) y los puntos suspensivos DENTRO de ese contenedor
                const shortText = container.querySelector('.short-text');
                const fullText = container.querySelector('.full-text');
                const dots = container.querySelector('.dots');

                // Verifica que todos los elementos necesarios existan
                if (!shortText || !fullText || !dots) return;

                // Comprueba el estado actual: ¿Está visible el texto completo?
                // Usamos offsetParent que es null si el elemento o un ancestro tiene display:none
                const isExpanded = fullText.offsetParent !== null;

                if (isExpanded) {
                    // ---- Acción: COLAPSAR (Mostrar Menos) ----
                    fullText.style.display = 'none'; // Oculta el texto completo
                    shortText.style.display = 'inline'; // Muestra el texto corto
                    dots.style.display = 'inline'; // Muestra los puntos suspensivos
                    this.textContent = 'Leer más'; // Cambia el texto del botón
                } else {
                    // ---- Acción: EXPANDIR (Mostrar Más) ----
                    shortText.style.display = 'none'; // Oculta el texto corto
                    dots.style.display = 'none'; // Oculta los puntos suspensivos
                    fullText.style.display =
                    'inline'; // Muestra el texto completo (usa 'block' si prefieres nueva línea)
                    this.textContent = 'Leer menos'; // Cambia el texto del botón
                }
            });
        });
    });
</script>
