<x-app-layout>
    @section('title', 'Infografías: Inicio')
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Infografías del Comité') }}
        </h2>
    </x-slot>
    @if ($message = Session::get('success'))
    <script>
        Swal.fire({
            icon: 'success',
            title: '{{ $message }}'
        })
    </script>
    @endif
    <div class="container py-12 mx-auto">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="" style="background-color: white; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);">
                <div class="container ">
                    @can('crear-infografia')
                    <a href="{{ route('panel-infografias.create') }}" title="Botón de Subir infografía">
                        <button class="btn btn-primary mt-3 mb-3 ml-3">Subir
                            nueva</button>
                    </a>
                    @endcan
                </div>
                <div class="container table-responsive">
                    @if (session('message'))
                    <div class="alert alert-success">
                        {{ session('message') }}
                    </div>
                    @endif
                    <table id="myTable" class="table table-striped" style="width:100%">
                        <thead>
                            <tr>
                                <th>Nombre</th>
                                <th>Fecha de publicación</th>
                                <th>Infografia</th>
                                <th>Fecha Subido</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if ($infografias)
                            @foreach ($infografias as $infografia)
                            <tr>
                                <td>{{ $infografia->nombre }}</td>
                                <td>
                                    {{ \Carbon\Carbon::parse($infografia->fecha_publicacion)->locale('es')->translatedFormat('d \d\e F \d\e Y') }}
                                </td>
                                <td>
                                    <a href="imagenes/infografias-carpeta/{{ $infografia->infografia }}"
                                        target="_blank" rel="noopener"
                                        title="Enlace a {{ $infografia->nombre }}">
                                        <img src="imagenes/infografias-carpeta/{{ $infografia->infografia }}"
                                            class="img-thumbnail" title="Infografía: {{ $infografia->nombre }}"
                                            alt="Infografía de {{ $infografia->nombre }}"
                                            style="max-height: 100px">
                                    </a>
                                </td>
                                <td>
                                    {{ \Carbon\Carbon::parse($infografia->created_at)->locale('es')->translatedFormat('d \d\e F \d\e Y') }}
                                </td>
                                <td>
                                    <div class="flex justify-center rounded-lg text-lg" role="group">
                                        @can('editar-infografia')
                                        <a href="{{ route('panel-infografias.edit', $infografia->id) }}"
                                            class="">
                                            <button class="btn btn-secondary">
                                                Editar
                                            </button>
                                        </a>
                                        @endcan
                                        @can('borrar-infografia')
                                        <form
                                            action="{{ route('panel-infografias.destroy', $infografia->id) }}"
                                            method="POST" class="formEliminar">
                                            @csrf
                                            @method('DELETE')
                                            <button style="color: black" type="submit"
                                                class="btn btn-danger">Borrar</button>
                                        </form>
                                        @endcan
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                            @endif
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>Nombre</th>

                                <th>Fecha de publicación</th>
                                <th>Infografia</th>
                                <th>Fecha Subido</th>
                                <th>Acciones</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
                {{-- <div>
                    {{ $DocumentoSubcomites->links() }}
            </div> --}}
        </div>
    </div>
    </div>
</x-app-layout>
<script>
    (function() {
        'use strict'
        //debemos crear la clase formEliminar dentro del form del boton borrar
        //recordar que cada registro a eliminar esta contenido en un form  
        var forms = document.querySelectorAll('.formEliminar')
        Array.prototype.slice.call(forms)
            .forEach(function(form) {
                form.addEventListener('submit', function(event) {
                    event.preventDefault()
                    event.stopPropagation()
                    Swal.fire({
                        title: '¿Confirma la eliminación del registro?',
                        icon: 'info',
                        showCancelButton: true,
                        confirmButtonColor: '#20c997',
                        cancelButtonColor: '#6c757d',
                        confirmButtonText: 'Confirmar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            this.submit();
                            Swal.fire('¡Eliminado!',
                                'El registro ha sido eliminado exitosamente.', 'success');
                        }
                    })
                }, false)
            })
    })()
</script>
<script>
    $(document).ready(function() {
        $('#myTable').DataTable({
            "pagingType": "simple_numbers",
            "order": [],
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ entradas",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "previous": "Anterior",
                    "next": "Siguiente"
                }
            }
        });
    });
</script>