<x-app-layout>
    @section('title', 'Infografías: Editar')
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Editar Infografías') }}
        </h2>
    </x-slot>

    <div class="container bg-white">
        <div class="form-container py-3">
            <div class="form-header py-3">
                <h2>Editar Infografía</h2>
            </div>
            <form action="{{ route('panel-infografias.update', $infografias->id) }}" method="POST"
                enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="container row">
                    <div class="col-md-8 my-2">
                        <div class="custom-section-title"><i class="fa-solid fa-file-signature"></i> Nombre de la
                            infografía: *
                        </div>
                        <input name="nombre" value="{{ $infografias->nombre }}" class="form-control" type="text"
                            required>
                        @error('nombre')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-4 my-2">
                        <div class="custom-section-title"><i class="fa-solid fa-calendar-check"></i>
                            Fecha de publicación: *
                        </div>
                        <input name="fecha_publicacion" value="{{ $infografias->fecha_publicacion }}"
                            class="form-control" type="date" required>
                        @error('fecha_publicacion')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="container">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="custom-section-title"><i class="fa-regular fa-image"></i>
                                Infografía actual: *
                            </div>
                            <div class="text-center">
                                <img src="/imagenes/infografias-carpeta/{{ $infografias->infografia }}" width="90%"
                                    id="infografiaSeleccionada" class="img-fluid">
                            </div>
                            <div class="col-md-12">
                                <div class="custom-section-title"><i class="fa-regular fa-image"></i>
                                    Subir nueva infografía: *
                                </div>
                                <div class="text-center">
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" id="infografia"
                                            name="infografia">
                                        @error('infografia')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                        <label class="custom-file-label" for="infografia">Seleccione la imagen</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="col-md-12">
                                <div class="custom-section-title"><i class="fa-regular fa-image"></i> Miniatura actual*
                                </div>
                                <div class="text-center">
                                    <img src="/imagenes/infografias-carpeta/miniaturas/{{ $infografias->miniatura }}"
                                        width="90%" id="miniaturaSeleccionada" class="img-fluid">
                                </div>
                            </div>
                            <div class="custom-section-title"><i class="fa-regular fa-image"></i> Subir nueva miniatura*
                            </div>
                            <div class="text-center">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" id="miniatura" name="miniatura">
                                    @error('miniatura')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                    <label class="custom-file-label" for="miniatura">Seleccione la imagen</label>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="row my-2">
                        <div class="d-flex justify-content-between">
                            <a href="{{ route('panel-infografias.index') }}"
                                class="btn btn-secondary w-100">Cancelar</a>
                            <button type="submit" class="btn btn-success w-100">Guardar</button>
                        </div>
                    </div>
                </div>

            </form>
        </div>
    </div>
</x-app-layout>

<script>
    $(document).ready(function(e) {
        $('#infografia').change(function() {
            let reader = new FileReader();
            reader.onload = (e) => {
                $('#infografiaSeleccionada').attr('src', e.target.result);
            }
            reader.readAsDataURL(this.files[0]);
        });
    });
    $(document).ready(function(e) {
        $('#miniatura').change(function() {
            let reader = new FileReader();
            reader.onload = (e) => {
                $('#miniaturaSeleccionada').attr('src', e.target.result);
            }
            reader.readAsDataURL(this.files[0]);
        });
    });
</script>
